/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.command.ChunkCommand;
import mekanism.common.command.ForceRetrogenCommand;
import mekanism.common.command.RadiationCommand;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;

public class CommandMek {
    private static final Map<UUID, Stack<BlockPos>> tpStack = new Object2ObjectOpenHashMap();

    private CommandMek() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mek").then(BuildCommand.COMMAND)).then(ChunkCommand.register())).then(DebugCommand.register())).then(ForceRetrogenCommand.register())).then(RadiationCommand.register())).then(TestRulesCommand.register())).then(TpCommand.register())).then(TppopCommand.register());
    }

    private static class DebugCommand {
        private DebugCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
                MekanismAPI.debug = !MekanismAPI.debug;
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)MekanismLang.COMMAND_DEBUG.translateColored(EnumColor.GRAY, BooleanStateDisplay.OnOff.of(MekanismAPI.debug, true)), true);
                return 0;
            });
        }
    }

    private static class TestRulesCommand {
        private TestRulesCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.m_82127_((String)"testrules").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                MinecraftServer server = source.m_81377_();
                GameRules rules = server.m_129900_();
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46133_)).m_46246_(true, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46134_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46140_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46150_)).m_46246_(false, server);
                ((GameRules.BooleanValue)rules.m_46170_(GameRules.f_46132_)).m_46246_(false, server);
                source.m_81372_().m_8615_(2000L);
                source.m_81354_((Component)MekanismLang.COMMAND_TEST_RULES.translateColored(EnumColor.GRAY, new Object[0]), true);
                return 0;
            });
        }
    }

    private static class TpCommand {
        private TpCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.m_82127_((String)"tp").requires(cs -> cs.m_6761_(2) && cs.m_81373_() instanceof ServerPlayer)).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = source.m_81375_();
                UUID uuid = player.m_142081_();
                Stack<BlockPos> playerLocations = tpStack.getOrDefault(uuid, new Stack());
                playerLocations.push(player.m_142538_());
                tpStack.put(uuid, playerLocations);
                Coordinates location = Vec3Argument.m_120849_((CommandContext)ctx, (String)"location");
                Vec3 position = location.m_6955_(source);
                player.f_8906_.m_9774_(position.m_7096_(), position.m_7098_(), position.m_7094_(), player.m_146908_(), player.m_146909_());
                source.m_81354_((Component)MekanismLang.COMMAND_TP.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TpCommand.getPosition(position)), true);
                return 0;
            }));
        }

        private static Component getPosition(Vec3 pos) {
            return MekanismLang.GENERIC_BLOCK_POS.translate(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        }
    }

    private static class TppopCommand {
        private static final SimpleCommandExceptionType TPOP_EMPTY = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_TPOP_EMPTY.translate(new Object[0]));

        private TppopCommand() {
        }

        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.m_82127_((String)"tpop").requires(cs -> cs.m_6761_(2) && cs.m_81373_() instanceof ServerPlayer)).executes(ctx -> {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = source.m_81375_();
                UUID uuid = player.m_142081_();
                Stack playerLocations = tpStack.getOrDefault(uuid, new Stack());
                if (playerLocations.isEmpty()) {
                    throw TPOP_EMPTY.create();
                }
                BlockPos lastPos = (BlockPos)playerLocations.pop();
                tpStack.put(uuid, playerLocations);
                player.f_8906_.m_9774_((double)lastPos.m_123341_(), (double)lastPos.m_123342_(), (double)lastPos.m_123343_(), player.m_146908_(), player.m_146909_());
                source.m_81354_((Component)MekanismLang.COMMAND_TPOP.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TppopCommand.getPosition(lastPos), EnumColor.INDIGO, playerLocations.size()), true);
                return 0;
            });
        }

        private static Component getPosition(BlockPos pos) {
            return MekanismLang.GENERIC_BLOCK_POS.translate(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
    }
}

