/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command.builders;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BuildCommand {
    private static final SimpleCommandExceptionType MISS = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_BUILD_MISS.translate(new Object[0]));
    public static final ArgumentBuilder<CommandSourceStack, ?> COMMAND = ((LiteralArgumentBuilder)Commands.m_82127_((String)"build").requires(cs -> cs.m_6761_(2) && cs.m_81373_() instanceof ServerPlayer)).then(Commands.m_82127_((String)"remove").executes(ctx -> {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        BlockHitResult result = MekanismUtils.rayTrace((Player)source.m_81375_(), 100.0);
        if (result.m_6662_() == HitResult.Type.MISS) {
            throw MISS.create();
        }
        BuildCommand.destroy((Level)source.m_81372_(), result.m_82425_());
        source.m_81354_((Component)MekanismLang.COMMAND_BUILD_REMOVED.translateColored(EnumColor.GRAY, new Object[0]), true);
        return 0;
    }));

    private BuildCommand() {
    }

    public static void register(String name, ILangEntry localizedName, StructureBuilder builder) {
        COMMAND.then(Commands.m_82127_((String)name).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            BlockHitResult result = MekanismUtils.rayTrace((Player)source.m_81375_(), 100.0);
            if (result.m_6662_() == HitResult.Type.MISS) {
                throw MISS.create();
            }
            BlockPos pos = result.m_82425_().m_142300_(Direction.UP);
            builder.build((Level)source.m_81372_(), pos);
            source.m_81354_((Component)MekanismLang.COMMAND_BUILD_BUILT.translateColored(EnumColor.GRAY, EnumColor.INDIGO, localizedName), true);
            return 0;
        }));
    }

    private static void destroy(Level world, BlockPos pos) throws CommandSyntaxException {
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        if (!BuildCommand.isMekanismBlock((LevelAccessor)world, (Long2ObjectMap<ChunkAccess>)chunkMap, pos)) {
            throw MISS.create();
        }
        HashSet<BlockPos> traversed = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> openSet = new ArrayDeque<BlockPos>();
        openSet.add(pos);
        traversed.add(pos);
        while (!openSet.isEmpty()) {
            BlockPos ptr = (BlockPos)openSet.poll();
            if (!BuildCommand.isMekanismBlock((LevelAccessor)world, (Long2ObjectMap<ChunkAccess>)chunkMap, ptr)) continue;
            Clearable.m_18908_((Object)WorldUtils.getTileEntity((LevelAccessor)world, (Long2ObjectMap<ChunkAccess>)chunkMap, ptr));
            world.m_7471_(ptr, false);
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos offset = ptr.m_142300_(side);
                if (!traversed.add(offset)) continue;
                openSet.add(offset);
            }
        }
    }

    private static boolean isMekanismBlock(@Nullable LevelAccessor world, @Nonnull Long2ObjectMap<ChunkAccess> chunkMap, @Nonnull BlockPos pos) {
        Optional<BlockState> state = WorldUtils.getBlockState(world, chunkMap, pos);
        return state.isPresent() && state.get().m_60734_().getRegistryName().m_135827_().startsWith("mekanism");
    }
}

