/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.multiblock.TileEntitySuperheatingElement;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class BoilerValidator
extends CuboidStructureValidator<BoilerMultiblockData> {
    @Override
    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.m_60734_();
        if (BlockType.is(block, MekanismBlockTypes.BOILER_CASING)) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is(block, MekanismBlockTypes.BOILER_VALVE)) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    @Override
    protected boolean validateInner(BlockState state, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        return BlockType.is(state.m_60734_(), MekanismBlockTypes.PRESSURE_DISPERSER, MekanismBlockTypes.SUPERHEATING_ELEMENT);
    }

    @Override
    public FormationProtocol.FormationResult postcheck(BoilerMultiblockData structure, Set<BlockPos> innerNodes, Long2ObjectMap<ChunkAccess> chunkMap) {
        ObjectOpenHashSet dispersers = new ObjectOpenHashSet();
        ObjectOpenHashSet elements = new ObjectOpenHashSet();
        for (BlockPos pos : innerNodes) {
            BlockEntity tile = WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, pos);
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(pos);
                continue;
            }
            if (!(tile instanceof TileEntitySuperheatingElement)) continue;
            structure.internalLocations.add(pos);
            elements.add(pos);
        }
        if (dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_NO_DISPERSER);
        }
        if (elements.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_SUPERHEATING);
        }
        BlockPos initDisperser = (BlockPos)dispersers.iterator().next();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = 1; x < structure.length() - 1; ++x) {
            for (int z = 1; z < structure.width() - 1; ++z) {
                mutablePos.m_122178_(structure.renderLocation.m_123341_() + x, initDisperser.m_123342_(), structure.renderLocation.m_123343_() + z);
                TileEntityPressureDisperser tile = WorldUtils.getTileEntity(TileEntityPressureDisperser.class, (LevelAccessor)this.world, chunkMap, (BlockPos)mutablePos);
                if (tile == null) {
                    return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_MISSING_DISPERSER, (BlockPos)mutablePos);
                }
                dispersers.remove(mutablePos);
            }
        }
        if (!dispersers.isEmpty()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_EXTRA_DISPERSER);
        }
        structure.superheatingElements = FormationProtocol.explore((BlockPos)elements.iterator().next(), coord -> coord.m_123342_() < initDisperser.m_123342_() && WorldUtils.getTileEntity(TileEntitySuperheatingElement.class, (LevelAccessor)this.world, chunkMap, coord) != null);
        if (elements.size() > structure.superheatingElements) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_SUPERHEATING);
        }
        BlockPos initAir = null;
        BlockPos.MutableBlockPos mutableAir = new BlockPos.MutableBlockPos();
        int totalAir = 0;
        for (int x = structure.renderLocation.m_123341_(); x < structure.renderLocation.m_123341_() + structure.length(); ++x) {
            for (int y = structure.renderLocation.m_123342_(); y < initDisperser.m_123342_(); ++y) {
                for (int z = structure.renderLocation.m_123343_(); z < structure.renderLocation.m_123343_() + structure.width(); ++z) {
                    mutableAir.m_122178_(x, y, z);
                    if (!this.isAirOrFrame(chunkMap, (BlockPos)mutableAir)) continue;
                    initAir = mutableAir.m_7949_();
                    ++totalAir;
                }
            }
        }
        BlockPos renderLocation = structure.renderLocation;
        int volLength = structure.length();
        int volWidth = structure.width();
        structure.setWaterVolume(FormationProtocol.explore(initAir, coord -> coord.m_123342_() >= renderLocation.m_123342_() - 1 && coord.m_123342_() < initDisperser.m_123342_() && coord.m_123341_() >= renderLocation.m_123341_() && coord.m_123341_() < renderLocation.m_123341_() + volLength && coord.m_123343_() >= renderLocation.m_123343_() && coord.m_123343_() < renderLocation.m_123343_() + volWidth && this.isAirOrFrame(chunkMap, (BlockPos)coord)));
        if (totalAir > structure.getWaterVolume()) {
            return FormationProtocol.FormationResult.fail(MekanismLang.BOILER_INVALID_AIR_POCKETS);
        }
        int steamHeight = structure.renderLocation.m_123342_() + structure.height() - 2 - initDisperser.m_123342_();
        structure.setSteamVolume(structure.width() * structure.length() * steamHeight);
        structure.upperRenderLocation = new BlockPos(structure.renderLocation.m_123341_(), initDisperser.m_123342_() + 1, structure.renderLocation.m_123343_());
        return FormationProtocol.FormationResult.SUCCESS;
    }

    private boolean isAirOrFrame(Long2ObjectMap<ChunkAccess> chunkMap, BlockPos airPos) {
        Optional<BlockState> stateOptional = WorldUtils.getBlockState((LevelAccessor)this.world, chunkMap, airPos);
        return stateOptional.isPresent() && stateOptional.get().m_60795_() || this.isFrameCompatible(WorldUtils.getTileEntity((LevelAccessor)this.world, chunkMap, airPos));
    }
}

