/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.to_client.PacketLightningRender;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.Lazy;

@ParametersAreNonnullByDefault
public class ModuleFarmingUnit
implements ICustomModule<ModuleFarmingUnit> {
    private IModuleConfigItem<FarmingRadius> farmingRadius;

    @Override
    public void init(IModule<ModuleFarmingUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.farmingRadius = configItemCreator.createConfigItem("farming_radius", MekanismLang.MODULE_FARMING_RADIUS, new ModuleEnumData<FarmingRadius>(FarmingRadius.class, module.getInstalledCount() + 1, FarmingRadius.LOW));
    }

    @Override
    @Nonnull
    public InteractionResult onItemUse(IModule<ModuleFarmingUnit> module, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || player.m_6144_()) {
            return InteractionResult.PASS;
        }
        int diameter = this.farmingRadius.get().getRadius();
        if (diameter == 0) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return InteractionResult.FAIL;
        }
        Lazy lazyClickedState = Lazy.of(() -> context.m_43725_().m_8055_(context.m_8083_()));
        return MekanismUtils.performActions(this.useAxeAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter, player, stack, ToolActions.AXE_STRIP, SoundEvents.f_11688_, -1), () -> this.useAxeAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter, player, stack, ToolActions.AXE_SCRAPE, SoundEvents.f_144059_, 3005), () -> this.useAxeAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter, player, stack, ToolActions.AXE_WAX_OFF, SoundEvents.f_144060_, 3004), () -> this.flattenAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter, player, stack), () -> this.dowseCampfire(context, (Lazy<BlockState>)lazyClickedState, energyContainer), () -> this.tillAOE(context, (Lazy<BlockState>)lazyClickedState, energyContainer, diameter, player, stack, (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageHoe.get()));
    }

    @Override
    public boolean canPerformAction(IModule<ModuleFarmingUnit> module, ToolAction action) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(action) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(action) || ToolActions.DEFAULT_HOE_ACTIONS.contains(action);
    }

    private InteractionResult dowseCampfire(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer) {
        FloatingLong energyUsage;
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage = (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShovel.get())) {
            return InteractionResult.FAIL;
        }
        BlockState clickedState = (BlockState)lazyClickedState.get();
        if (clickedState.m_60734_() instanceof CampfireBlock && ((Boolean)clickedState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            if (!world.m_5776_()) {
                world.m_5898_(null, 1009, pos, 0);
            }
            CampfireBlock.m_152749_((Entity)context.m_43723_(), (LevelAccessor)world, (BlockPos)pos, (BlockState)clickedState);
            if (!world.m_5776_()) {
                world.m_7731_(pos, (BlockState)clickedState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.FALSE), 11);
                energyContainer.extract(energyUsage, Action.EXECUTE, AutomationType.MANUAL);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tillAOE(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer, int diameter, Player player, ItemStack stack, FloatingLong energyUsage) {
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage)) {
            return InteractionResult.FAIL;
        }
        Block type = ((BlockState)lazyClickedState.get()).m_60734_();
        Pair conversion = (Pair)HoeItem.f_41332_.get(type);
        if (conversion == null) {
            return InteractionResult.PASS;
        }
        Predicate canConvert = (Predicate)conversion.getFirst();
        if (!canConvert.test(context)) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Consumer converter = (Consumer)conversion.getSecond();
        converter.accept(context);
        BlockPos pos = context.m_8083_();
        world.m_5594_(null, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
        FloatingLong energyUsed = energyUsage;
        int radius = (diameter - 1) / 2;
        for (BlockPos newPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-radius, 0, -radius), (BlockPos)pos.m_142082_(radius, 0, radius))) {
            if (pos.equals((Object)newPos)) continue;
            FloatingLong nextEnergyUsed = energyUsed.add(energyUsage);
            if (nextEnergyUsed.greaterThan(energy)) break;
            if (!world.m_8055_(newPos).m_60713_(type)) continue;
            newPos = newPos.m_7949_();
            UseOnContext adjustedContext = new UseOnContext(world, player, context.m_43724_(), stack, new BlockHitResult(context.m_43720_().m_82520_((double)(newPos.m_123341_() - pos.m_123341_()), (double)(newPos.m_123342_() - pos.m_123342_()), (double)(newPos.m_123343_() - pos.m_123343_())), context.m_43719_(), newPos, context.m_43721_()));
            if (!canConvert.test(adjustedContext)) continue;
            energyUsed = nextEnergyUsed;
            converter.accept(adjustedContext);
            world.m_5594_(null, newPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            Mekanism.packetHandler().sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(pos, newPos), Vec3.m_82514_((Vec3i)pos, (double)0.94), Vec3.m_82514_((Vec3i)newPos, (double)0.94), 10), world, pos);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
        return InteractionResult.CONSUME;
    }

    private InteractionResult flattenAOE(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer, int diameter, Player player, ItemStack stack) {
        Direction sideHit = context.m_43719_();
        if (sideHit == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        return this.useAOE(context, lazyClickedState, energyContainer, diameter, player, stack, ToolActions.SHOVEL_FLATTEN, SoundEvents.f_12406_, -1, (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShovel.get(), new ShovelToolAOEData());
    }

    private InteractionResult useAxeAOE(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer, int diameter, Player player, ItemStack stack, ToolAction action, SoundEvent sound, int particle) {
        return this.useAOE(context, lazyClickedState, energyContainer, diameter, player, stack, action, sound, particle, (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageAxe.get(), new AxeToolAOEData());
    }

    private InteractionResult useAOE(UseOnContext context, Lazy<BlockState> lazyClickedState, IEnergyContainer energyContainer, int diameter, Player player, ItemStack stack, ToolAction action, SoundEvent sound, int particle, FloatingLong energyUsage, IToolAOEData toolAOEData) {
        FloatingLong energy = energyContainer.getEnergy();
        if (energy.smallerThan(energyUsage)) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState clickedState = (BlockState)lazyClickedState.get();
        BlockState modifiedState = clickedState.getToolModifiedState(world, pos, player, stack, action);
        if (modifiedState == null || !toolAOEData.isValid(world, pos, clickedState)) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        world.m_7731_(pos, modifiedState, 11);
        world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (particle != -1) {
            world.m_5898_(null, particle, pos, 0);
        }
        Direction side = context.m_43719_();
        toolAOEData.persistData(world, pos, clickedState, side);
        FloatingLong energyUsed = energyUsage;
        for (BlockPos newPos : toolAOEData.getTargetPositions(pos, side, (diameter - 1) / 2)) {
            if (pos.equals((Object)newPos)) continue;
            FloatingLong nextEnergyUsed = energyUsed.add(energyUsage);
            if (nextEnergyUsed.greaterThan(energy)) break;
            BlockState state = world.m_8055_(newPos);
            if (!toolAOEData.isValid(world, newPos, state) || modifiedState != state.getToolModifiedState(world, newPos, player, stack, action)) continue;
            newPos = newPos.m_7949_();
            energyUsed = nextEnergyUsed;
            world.m_7731_(newPos, modifiedState, 11);
            world.m_5594_(null, newPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (particle != -1) {
                world.m_5898_(null, particle, newPos, 0);
            }
            Mekanism.packetHandler().sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(pos, newPos), toolAOEData.getLightningPos(pos), toolAOEData.getLightningPos(newPos), 10), world, pos);
        }
        energyContainer.extract(energyUsed, Action.EXECUTE, AutomationType.MANUAL);
        return InteractionResult.CONSUME;
    }

    public static enum FarmingRadius implements IHasTextComponent
    {
        OFF(0),
        LOW(1),
        MED(3),
        HIGH(5),
        ULTRA(7);

        private final int radius;
        private final Component label;

        private FarmingRadius(int radius) {
            this.radius = radius;
            this.label = TextComponentUtil.getString(Integer.toString(radius));
        }

        @Override
        public Component getTextComponent() {
            return this.label;
        }

        public int getRadius() {
            return this.radius;
        }
    }

    private static class ShovelToolAOEData
    implements IToolAOEData {
        private ShovelToolAOEData() {
        }

        @Override
        public boolean isValid(Level level, BlockPos pos, BlockState state) {
            BlockPos abovePos = pos.m_7494_();
            BlockState aboveState = level.m_8055_(abovePos);
            if (aboveState.m_60795_()) {
                return true;
            }
            Material material = aboveState.m_60767_();
            if (material == Material.f_76302_ || material == Material.f_76303_) {
                return !aboveState.m_60804_((BlockGetter)level, abovePos);
            }
            return false;
        }

        @Override
        public Iterable<BlockPos> getTargetPositions(BlockPos pos, Direction side, int radius) {
            return BlockPos.m_121940_((BlockPos)pos.m_142082_(-radius, 0, -radius), (BlockPos)pos.m_142082_(radius, 0, radius));
        }

        @Override
        public Vec3 getLightningPos(BlockPos pos) {
            return Vec3.m_82514_((Vec3i)pos, (double)0.94);
        }
    }

    private static interface IToolAOEData {
        public boolean isValid(Level var1, BlockPos var2, BlockState var3);

        default public void persistData(Level level, BlockPos pos, BlockState state, Direction side) {
        }

        public Iterable<BlockPos> getTargetPositions(BlockPos var1, Direction var2, int var3);

        public Vec3 getLightningPos(BlockPos var1);
    }

    private static class AxeToolAOEData
    implements IToolAOEData {
        @Nullable
        private Direction.Axis axis;
        private boolean isSet;
        private Vec3 offset = Vec3.f_82478_;

        private AxeToolAOEData() {
        }

        @Override
        public boolean isValid(Level level, BlockPos blockPos, BlockState state) {
            return !this.isSet || this.axis == this.getAxis(state);
        }

        @Override
        public void persistData(Level level, BlockPos pos, BlockState state, Direction side) {
            this.axis = this.getAxis(state);
            this.isSet = true;
            this.offset = Vec3.m_82528_((Vec3i)side.m_122436_()).m_82490_(0.5);
        }

        @Override
        public Iterable<BlockPos> getTargetPositions(BlockPos pos, Direction side, int radius) {
            AABB box = switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.EAST, Direction.WEST -> new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() - radius), (double)(pos.m_123343_() - radius), (double)pos.m_123341_(), (double)(pos.m_123342_() + radius), (double)(pos.m_123343_() + radius));
                case Direction.UP, Direction.DOWN -> new AABB((double)(pos.m_123341_() - radius), (double)pos.m_123342_(), (double)(pos.m_123343_() - radius), (double)(pos.m_123341_() + radius), (double)pos.m_123342_(), (double)(pos.m_123343_() + radius));
                case Direction.SOUTH, Direction.NORTH -> new AABB((double)(pos.m_123341_() - radius), (double)(pos.m_123342_() - radius), (double)pos.m_123343_(), (double)(pos.m_123341_() + radius), (double)(pos.m_123342_() + radius), (double)pos.m_123343_());
            };
            return BlockPos.m_121940_((BlockPos)new BlockPos(box.f_82288_, box.f_82289_, box.f_82290_), (BlockPos)new BlockPos(box.f_82291_, box.f_82292_, box.f_82293_));
        }

        @Nullable
        private Direction.Axis getAxis(BlockState state) {
            return state.m_61138_((Property)RotatedPillarBlock.f_55923_) ? (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_) : null;
        }

        @Override
        public Vec3 getLightningPos(BlockPos pos) {
            return Vec3.m_82512_((Vec3i)pos).m_82549_(this.offset);
        }
    }
}

