/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.bytes.Byte2IntArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.math.MathUtils;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.InsertableSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class QIOCraftingTransferHelper {
    public final Map<HashedItem, HashedItemSource> reverseLookup = new HashMap<HashedItem, HashedItemSource>();
    private byte emptyInventorySlots;
    private boolean isValid = true;

    public QIOCraftingTransferHelper(Object2LongMap<HashedItem.UUIDAwareHashedItem> cachedInventory, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots, QIOCraftingWindow craftingWindow, Player player) {
        byte inventorySlotIndex;
        for (Object2LongMap.Entry entry : cachedInventory.object2LongEntrySet()) {
            HashedItem.UUIDAwareHashedItem source = (HashedItem.UUIDAwareHashedItem)entry.getKey();
            this.reverseLookup.computeIfAbsent(source.asRawHashedItem(), item -> new HashedItemSource()).addQIOSlot(source.getUUID(), entry.getLongValue());
        }
        for (inventorySlotIndex = 0; inventorySlotIndex < 9; inventorySlotIndex = (byte)(inventorySlotIndex + 1)) {
            CraftingWindowInventorySlot slot = craftingWindow.getInputSlot(inventorySlotIndex);
            if (slot.isEmpty()) continue;
            if (!slot.extractItem(1, Action.SIMULATE, AutomationType.MANUAL).m_41619_()) {
                this.reverseLookup.computeIfAbsent(HashedItem.raw(slot.getStack()), item -> new HashedItemSource()).addSlot(inventorySlotIndex, slot.getCount());
                continue;
            }
            this.isValid = false;
            return;
        }
        inventorySlotIndex = this.addSlotsToMap(player, hotBarSlots, inventorySlotIndex);
        this.addSlotsToMap(player, mainInventorySlots, inventorySlotIndex);
    }

    private byte addSlotsToMap(Player player, List<? extends Slot> slots, byte inventorySlotIndex) {
        for (Slot slot : slots) {
            if (slot.m_6657_()) {
                if (slot.m_8010_(player)) {
                    ItemStack stack = slot.m_7993_();
                    this.reverseLookup.computeIfAbsent(HashedItem.raw(stack), item -> new HashedItemSource()).addSlot(inventorySlotIndex, stack.m_41613_());
                }
            } else {
                this.emptyInventorySlots = (byte)(this.emptyInventorySlots + 1);
            }
            inventorySlotIndex = (byte)(inventorySlotIndex + 1);
        }
        return inventorySlotIndex;
    }

    public boolean isInvalid() {
        return !this.isValid;
    }

    public byte getEmptyInventorySlots() {
        return this.emptyInventorySlots;
    }

    @Nullable
    public HashedItemSource getSource(@Nonnull HashedItem item) {
        return this.reverseLookup.get(item);
    }

    public static class HashedItemSource {
        @Nullable
        private Object2LongMap<UUID> qioSources;
        @Nullable
        private Byte2IntMap slots;
        private long available;
        private long matches;

        public long getAvailable() {
            return this.available;
        }

        public void matchFound() {
            ++this.matches;
        }

        public boolean hasMoreRemaining() {
            return this.available > this.matches;
        }

        private void addQIOSlot(UUID source, long stored) {
            if (this.qioSources == null) {
                this.qioSources = new Object2LongOpenHashMap();
            }
            this.qioSources.put((Object)source, stored);
            this.available += stored;
        }

        private void addSlot(byte slot, int count) {
            if (this.slots == null) {
                this.slots = new Byte2IntArrayMap();
            }
            this.slots.put(slot, count);
            this.available += (long)count;
        }

        public int getSlotRemaining(byte slot) {
            if (this.slots == null) {
                return 0;
            }
            return this.slots.getOrDefault(slot, 0);
        }

        public long getQIORemaining(UUID uuid) {
            if (this.qioSources == null) {
                return 0L;
            }
            return this.qioSources.getOrDefault((Object)uuid, 0L);
        }

        public boolean hasQIOSources() {
            return this.qioSources != null;
        }

        public List<SingularHashedItemSource> use(int toUse) {
            Byte2IntMap.Entry entry;
            ObjectIterator iter;
            if ((long)toUse > this.available) {
                return Collections.emptyList();
            }
            --this.matches;
            ArrayList<SingularHashedItemSource> sources = new ArrayList<SingularHashedItemSource>();
            if (this.slots != null) {
                iter = this.slots.byte2IntEntrySet().iterator();
                while (iter.hasNext()) {
                    entry = (Byte2IntMap.Entry)iter.next();
                    int stored = entry.getIntValue();
                    byte slot = entry.getByteKey();
                    if (stored > toUse) {
                        this.slots.put(slot, stored - toUse);
                        this.available -= (long)toUse;
                        sources.add(new SingularHashedItemSource(slot, toUse));
                        return sources;
                    }
                    this.available -= (long)stored;
                    sources.add(new SingularHashedItemSource(slot, MathUtils.clampToInt(stored)));
                    iter.remove();
                    if (stored == toUse) {
                        return sources;
                    }
                    toUse -= stored;
                }
            }
            if (this.qioSources != null) {
                iter = this.qioSources.object2LongEntrySet().iterator();
                while (iter.hasNext()) {
                    entry = (Object2LongMap.Entry)iter.next();
                    long stored = entry.getLongValue();
                    UUID key = (UUID)entry.getKey();
                    if (stored > (long)toUse) {
                        this.qioSources.put((Object)key, stored - (long)toUse);
                        this.available -= (long)toUse;
                        sources.add(new SingularHashedItemSource(key, toUse));
                        return sources;
                    }
                    this.available -= stored;
                    sources.add(new SingularHashedItemSource(key, MathUtils.clampToInt(stored)));
                    iter.remove();
                    if (stored == (long)toUse) {
                        return sources;
                    }
                    toUse = (int)((long)toUse - stored);
                }
            }
            return Collections.emptyList();
        }
    }

    public static abstract class BaseSimulatedInventory {
        private final ItemStack[] inventory;
        private final int[] stackSizes;
        private final int[] slotLimits;

        protected BaseSimulatedInventory(List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
            int hotBarSize = hotBarSlots.size();
            int slots = hotBarSize + mainInventorySlots.size();
            this.inventory = new ItemStack[slots];
            this.stackSizes = new int[slots];
            this.slotLimits = new int[slots];
            for (int slot = 0; slot < slots; ++slot) {
                InsertableSlot inventorySlot = slot < hotBarSize ? (InsertableSlot)hotBarSlots.get(slot) : (InsertableSlot)mainInventorySlots.get(slot - hotBarSize);
                ItemStack stack = inventorySlot.m_7993_();
                int remaining = this.getRemaining(slot, stack);
                if (remaining == 0) {
                    stack = ItemStack.f_41583_;
                }
                this.stackSizes[slot] = remaining;
                this.inventory[slot] = stack;
                this.slotLimits[slot] = stack.m_41619_() ? inventorySlot.m_5866_(stack) : Math.min(inventorySlot.m_5866_(stack), stack.m_41741_());
            }
        }

        protected abstract int getRemaining(int var1, ItemStack var2);

        public int shuffleItem(HashedItem type, int amount) {
            int slot;
            if (amount == 0) {
                return 0;
            }
            ItemStack stack = type.getStack();
            for (slot = 0; slot < this.inventory.length; ++slot) {
                int currentAmount = this.stackSizes[slot];
                int max = this.slotLimits[slot];
                if (currentAmount >= max || !ItemHandlerHelper.canItemStacksStack((ItemStack)this.inventory[slot], (ItemStack)stack)) continue;
                int toPlace = Math.min(max - currentAmount, amount);
                this.stackSizes[slot] = currentAmount + toPlace;
                if ((amount -= toPlace) != 0) continue;
                return 0;
            }
            for (slot = 0; slot < this.inventory.length; ++slot) {
                int toPlace;
                int max;
                if (!this.inventory[slot].m_41619_() || (max = this.slotLimits[slot]) <= 0) continue;
                this.inventory[slot] = stack;
                this.slotLimits[slot] = max = Math.min(max, stack.m_41741_());
                if ((amount -= (toPlace = (this.stackSizes[slot] = Math.min(amount, max)))) != 0) continue;
                return 0;
            }
            return amount;
        }

        @Nullable
        public Object2IntMap<HashedItem> shuffleInputs(Object2IntMap<HashedItem> leftOverInput, boolean hasFrequency) {
            Object2IntMap stillLeftOver = hasFrequency ? new Object2IntArrayMap(leftOverInput.size()) : Object2IntMaps.emptyMap();
            for (Object2IntMap.Entry entry : leftOverInput.object2IntEntrySet()) {
                int remaining = this.shuffleItem((HashedItem)entry.getKey(), entry.getIntValue());
                if (remaining <= 0) continue;
                if (!hasFrequency) {
                    return null;
                }
                stillLeftOver.put((Object)((HashedItem)entry.getKey()), remaining);
            }
            return stillLeftOver;
        }
    }

    public static class SingularHashedItemSource {
        @Nullable
        private final UUID qioSource;
        private final byte slot;
        private int used;

        public SingularHashedItemSource(@Nonnull UUID qioSource, int used) {
            this.qioSource = qioSource;
            this.slot = (byte)-1;
            this.used = used;
        }

        public SingularHashedItemSource(byte slot, int used) {
            this.qioSource = null;
            this.slot = slot;
            this.used = used;
        }

        public int getUsed() {
            return this.used;
        }

        public void setUsed(int used) {
            if (used < 0 || used > this.used) {
                throw new IllegalArgumentException("Used must be a lower amount than currently being used if getting updated.");
            }
            this.used = used;
        }

        public byte getSlot() {
            return this.slot;
        }

        @Nullable
        public UUID getQioSource() {
            return this.qioSource;
        }
    }
}

