/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import mekanism.common.base.TagCache;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class SearchQueryParser {
    private static final ISearchQuery INVALID = stack -> false;
    private static final Set<Character> TERMINATORS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('|'), Character.valueOf('('), Character.valueOf('\"'), Character.valueOf('\'')});

    public static ISearchQuery parse(String query) {
        ArrayList<SearchQuery> ret = new ArrayList<SearchQuery>();
        SearchQuery curQuery = new SearchQuery();
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '|') {
                if (!curQuery.isEmpty()) {
                    ret.add(curQuery);
                }
                curQuery = new SearchQuery();
                continue;
            }
            if (c == ' ') continue;
            QueryType type = QueryType.get(c);
            if (type != null) {
                ++i;
            } else {
                type = QueryType.NAME;
            }
            KeyListResult keyListResult = SearchQueryParser.readKeyList(query, i, type, curQuery);
            if (!keyListResult.hasResult()) {
                return INVALID;
            }
            i = keyListResult.index();
        }
        if (!curQuery.isEmpty()) {
            ret.add(curQuery);
        }
        return new SearchQueryList(ret);
    }

    private static KeyListResult readKeyList(String query, int start, QueryType type, SearchQuery curQuery) {
        int newIndex;
        List<String> keys;
        if (start >= query.length()) {
            return new KeyListResult(true, start);
        }
        char qc = query.charAt(start);
        if (qc == '(') {
            ListResult<String> listResult = SearchQueryParser.readList(query, start);
            if (listResult == null) {
                return KeyListResult.INVALID;
            }
            keys = listResult.result();
            newIndex = listResult.index();
        } else if (qc == '\"' || qc == '\'') {
            Result quoteResult = SearchQueryParser.readQuote(query, start);
            if (quoteResult == null) {
                return KeyListResult.INVALID;
            }
            keys = Collections.singletonList(quoteResult.result());
            newIndex = quoteResult.index();
        } else {
            Result textResult = SearchQueryParser.readUntilTermination(query, start, type != QueryType.NAME);
            keys = Collections.singletonList(textResult.result());
            newIndex = textResult.index();
        }
        if (!keys.isEmpty()) {
            curQuery.queryStrings.put(type, keys);
        }
        return new KeyListResult(true, newIndex);
    }

    @Nullable
    private static ListResult<String> readList(String query, int start) {
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = start + 1; i < query.length(); ++i) {
            String key;
            char qc = query.charAt(i);
            if (qc == ')') {
                key = sb.toString().trim();
                if (!key.isEmpty()) {
                    ret.add(key);
                }
                return new ListResult<String>(ret, i);
            }
            if (qc == '|') {
                key = sb.toString().trim();
                if (!key.isEmpty()) {
                    ret.add(key);
                }
                sb = new StringBuilder();
                continue;
            }
            if (qc == '\"' || qc == '\'') {
                Result quoteResult = SearchQueryParser.readQuote(query, i);
                if (quoteResult == null) {
                    return null;
                }
                ret.add(quoteResult.result());
                i = quoteResult.index();
                continue;
            }
            sb.append(qc);
        }
        return null;
    }

    @Nullable
    private static Result readQuote(String text, int start) {
        char quoteChar = text.charAt(start);
        StringBuilder ret = new StringBuilder();
        for (int i = start + 1; i < text.length(); ++i) {
            char tc = text.charAt(i);
            if (tc == quoteChar) {
                return new Result(ret.toString(), i);
            }
            ret.append(tc);
        }
        return null;
    }

    private static Result readUntilTermination(String text, int start, boolean spaceTerminate) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = start; i < text.length(); ++i) {
            char tc = text.charAt(i);
            if (TERMINATORS.contains(Character.valueOf(tc)) || QueryType.get(tc) != null || spaceTerminate && tc == ' ') {
                --i;
                break;
            }
            sb.append(tc);
        }
        return new Result(sb.toString().trim(), i);
    }

    public static class SearchQuery
    implements ISearchQuery {
        private final Map<QueryType, List<String>> queryStrings = new LinkedHashMap<QueryType, List<String>>();

        @Override
        public boolean matches(ItemStack stack) {
            return this.queryStrings.entrySet().stream().allMatch(entry -> ((List)entry.getValue()).stream().anyMatch(key -> ((QueryType)((Object)((Object)((Object)entry.getKey())))).matches((String)key, stack)));
        }

        private boolean isEmpty() {
            return this.queryStrings.isEmpty();
        }

        protected Map<QueryType, List<String>> getQueryMap() {
            return this.queryStrings;
        }

        public String toString() {
            return this.queryStrings.toString();
        }
    }

    public static enum QueryType {
        NAME('~', (key, stack) -> stack.m_41786_().getString().toLowerCase(Locale.ROOT).contains(key.toLowerCase(Locale.ROOT))),
        MOD_ID('@', (key, stack) -> MekanismUtils.getModId(stack).toLowerCase(Locale.ROOT).contains(key.toLowerCase(Locale.ROOT))),
        TOOLTIP('$', (key, stack) -> stack.m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL).stream().map(t -> t.getString().toLowerCase(Locale.ROOT)).anyMatch(tooltip -> tooltip.contains(key.toLowerCase(Locale.ROOT)))),
        TAG('#', (key, stack) -> TagCache.getItemTags(stack).stream().anyMatch(itemTag -> itemTag.toLowerCase(Locale.ROOT).contains(key.toLowerCase(Locale.ROOT))));

        private static final Char2ObjectMap<QueryType> charLookupMap;
        private final char prefix;
        private final BiPredicate<String, ItemStack> checker;

        public static QueryType get(char prefix) {
            return (QueryType)((Object)charLookupMap.get(prefix));
        }

        public static CharSet getPrefixChars() {
            return charLookupMap.keySet();
        }

        private QueryType(char prefix, BiPredicate<String, ItemStack> checker) {
            this.prefix = prefix;
            this.checker = checker;
        }

        public boolean matches(String key, ItemStack stack) {
            return this.checker.test(key, stack);
        }

        static {
            QueryType[] values = QueryType.values();
            charLookupMap = new Char2ObjectArrayMap(values.length);
            for (QueryType type : values) {
                charLookupMap.put(type.prefix, (Object)type);
            }
        }
    }

    private record KeyListResult(boolean hasResult, int index) {
        public static final KeyListResult INVALID = new KeyListResult(false, -1);
    }

    public static interface ISearchQuery {
        public boolean matches(ItemStack var1);

        default public boolean isInvalid() {
            return this == INVALID;
        }
    }

    public static class SearchQueryList
    implements ISearchQuery {
        private final List<SearchQuery> queries;

        private SearchQueryList(List<SearchQuery> queries) {
            this.queries = queries;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return this.queries.isEmpty() || this.queries.stream().anyMatch(query -> query.matches(stack));
        }

        public String toString() {
            return this.queries.toString();
        }

        protected List<SearchQuery> getQueries() {
            return this.queries;
        }
    }

    private record ListResult<TYPE>(List<TYPE> result, int index) {
    }

    private record Result(String result, int index) {
    }
}

