/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.common.content.network.InventoryNetwork;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class PathfinderCache {
    private static final Map<UUID, Map<PathData, CachedPath>> cachedPaths = new Object2ObjectOpenHashMap();

    private PathfinderCache() {
    }

    public static void onChanged(InventoryNetwork ... networks) {
        for (InventoryNetwork network : networks) {
            cachedPaths.remove(network.getUUID());
        }
    }

    public static void addCachedPath(LogisticalTransporterBase start, PathData data, List<BlockPos> positions, double cost) {
        cachedPaths.computeIfAbsent(((InventoryNetwork)start.getTransmitterNetwork()).getUUID(), uuid -> new Object2ObjectOpenHashMap()).put(data, new CachedPath(positions, cost));
    }

    public static CachedPath getCache(LogisticalTransporterBase start, BlockPos end, Set<Direction> sides) {
        CachedPath ret = null;
        UUID uuid = ((InventoryNetwork)start.getTransmitterNetwork()).getUUID();
        if (cachedPaths.containsKey(uuid)) {
            Map<PathData, CachedPath> pathMap = cachedPaths.get(uuid);
            for (Direction side : sides) {
                CachedPath test = pathMap.get(new PathData(start.getTilePos(), end, side));
                if (ret != null && (test == null || !(test.cost() < ret.cost()))) continue;
                ret = test;
            }
        }
        return ret;
    }

    public static void reset() {
        cachedPaths.clear();
    }

    public record CachedPath(List<BlockPos> path, double cost) {
    }

    public static class PathData {
        private final BlockPos startTransporter;
        private final BlockPos end;
        private final Direction endSide;
        private final int hash;

        public PathData(BlockPos s, BlockPos e, Direction es) {
            this.startTransporter = s;
            this.end = e;
            this.endSide = es;
            int code = 1;
            code = 31 * code + this.startTransporter.hashCode();
            code = 31 * code + this.end.hashCode();
            this.hash = code = 31 * code + this.endSide.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof PathData)) return false;
            PathData data = (PathData)obj;
            if (!data.startTransporter.equals((Object)this.startTransporter)) return false;
            if (!data.end.equals((Object)this.end)) return false;
            if (!data.endSide.equals((Object)this.endSide)) return false;
            return true;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

