/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SpecialComputerMethodWrapper {

    public static class ComputerHeatCapacitorWrapper
    extends SpecialComputerMethodWrapper {
        public static double getTemperature(IHeatCapacitor capacitor) {
            return capacitor.getTemperature();
        }
    }

    public static class ComputerIInventorySlotWrapper
    extends SpecialComputerMethodWrapper {
        public static ItemStack getStack(IInventorySlot slot) {
            return slot.getStack();
        }
    }

    public static class ComputerFluidTankWrapper
    extends SpecialComputerMethodWrapper {
        @WrappingComputerMethod.WrappingComputerMethodIndex(value=0)
        public static FluidStack getStack(IExtendedFluidTank tank) {
            return tank.getFluid();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=1)
        public static int getCapacity(IExtendedFluidTank tank) {
            return tank.getCapacity();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=2)
        public static int getNeeded(IExtendedFluidTank tank) {
            return tank.getNeeded();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=3)
        public static double getFilledPercentage(IExtendedFluidTank tank) {
            return (double)tank.getFluidAmount() / (double)tank.getCapacity();
        }
    }

    public static class ComputerChemicalTankWrapper
    extends SpecialComputerMethodWrapper {
        @WrappingComputerMethod.WrappingComputerMethodIndex(value=0)
        public static ChemicalStack<?> getStack(IChemicalTank<?, ?> tank) {
            return tank.getStack();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=1)
        public static long getCapacity(IChemicalTank<?, ?> tank) {
            return tank.getCapacity();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=2)
        public static long getNeeded(IChemicalTank<?, ?> tank) {
            return tank.getNeeded();
        }

        @WrappingComputerMethod.WrappingComputerMethodIndex(value=3)
        public static double getFilledPercentage(IChemicalTank<?, ?> tank) {
            return (double)tank.getStored() / (double)tank.getCapacity();
        }
    }
}

