/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.opencomputers2;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import li.cil.oc2.api.bus.device.rpc.RPCInvocation;
import li.cil.oc2.api.bus.device.rpc.RPCMethod;
import li.cil.oc2.api.bus.device.rpc.RPCMethodGroup;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.opencomputers2.MekanismRPCMethod;
import mekanism.common.integration.computer.opencomputers2.OC2ArgumentWrapper;
import mekanism.common.integration.computer.opencomputers2.SelectedRPCMethod;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
public class MekanismRPCMethodGroup
implements RPCMethodGroup {
    private final Map<BoundComputerMethod.ThreadAwareMethodHandle, MekanismRPCMethod> mappedMethods;
    private final BoundComputerMethod method;
    private final Set<RPCMethod> overloads;
    private final String name;

    MekanismRPCMethodGroup(String name, BoundComputerMethod method) {
        this.name = name;
        this.method = method;
        List<BoundComputerMethod.ThreadAwareMethodHandle> implementations = method.getImplementations();
        this.mappedMethods = new HashMap<BoundComputerMethod.ThreadAwareMethodHandle, MekanismRPCMethod>(implementations.size());
        for (BoundComputerMethod.ThreadAwareMethodHandle methodHandle : implementations) {
            this.mappedMethods.put(methodHandle, new MekanismRPCMethod(name, method, methodHandle));
        }
        this.overloads = ImmutableSet.copyOf(this.mappedMethods.values());
    }

    public String getName() {
        return this.name;
    }

    public Optional<RPCMethod> findOverload(@Nonnull RPCInvocation invocation) {
        OC2ArgumentWrapper argumentWrapper = new OC2ArgumentWrapper(invocation);
        try {
            BoundComputerMethod.SelectedMethodInfo selected = this.method.findMatchingImplementation(argumentWrapper);
            MekanismRPCMethod impl = this.mappedMethods.get(selected.getMethod());
            if (impl != null) {
                return Optional.of(new SelectedRPCMethod(impl, selected, invocation));
            }
        }
        catch (ComputerException computerException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public Set<RPCMethod> getOverloads() {
        return this.overloads;
    }
}

