/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;

public class CrTUtils {
    public static ResourceLocation rl(String path) {
        return new ResourceLocation("crafttweaker", path);
    }

    public static ICrTChemicalStack.ICrTGasStack stackFromGas(Gas gas) {
        return new CrTChemicalStack.CrTGasStack(gas.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTInfusionStack stackFromInfuseType(InfuseType infuseType) {
        return new CrTChemicalStack.CrTInfusionStack(infuseType.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTPigmentStack stackFromPigment(Pigment pigment) {
        return new CrTChemicalStack.CrTPigmentStack(pigment.getStack(1L));
    }

    public static ICrTChemicalStack.ICrTSlurryStack stackFromSlurry(Slurry slurry) {
        return new CrTChemicalStack.CrTSlurryStack(slurry.getStack(1L));
    }

    @Nullable
    public static ICrTChemicalStack<?, ?, ?> fromBoxedStack(BoxedChemicalStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        return switch (stack.getChemicalType()) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> new CrTChemicalStack.CrTGasStack((GasStack)stack.getChemicalStack());
            case ChemicalType.INFUSION -> new CrTChemicalStack.CrTInfusionStack((InfusionStack)stack.getChemicalStack());
            case ChemicalType.PIGMENT -> new CrTChemicalStack.CrTPigmentStack((PigmentStack)stack.getChemicalStack());
            case ChemicalType.SLURRY -> new CrTChemicalStack.CrTSlurryStack((SlurryStack)stack.getChemicalStack());
        };
    }

    public static <TYPE> String describeOutputs(List<TYPE> outputs, Function<TYPE, Object> converter) {
        int size = outputs.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return converter.apply(outputs.get(0)).toString();
        }
        StringBuilder description = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                description.append(", or ");
            }
            description.append(converter.apply(outputs.get(i)));
        }
        return description.toString();
    }

    public static <TYPE> TagKey<TYPE> validateTagAndGet(KnownTag<TYPE> tag) {
        if (tag.exists()) {
            return tag.getTagKey();
        }
        throw new IllegalArgumentException("Tag " + tag.getCommandString() + " does not exist.");
    }

    public static <TYPE, CRT_TYPE> List<CRT_TYPE> convert(List<TYPE> elements, Function<TYPE, CRT_TYPE> converter) {
        return elements.stream().map(converter).toList();
    }

    public static KnownTagManager<Item> itemTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registry.f_122904_);
    }

    public static KnownTagManager<Fluid> fluidTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registry.f_122899_);
    }

    public static KnownTagManager<Gas> gasTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.gasRegistryName());
    }

    public static KnownTagManager<InfuseType> infuseTypeTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.infuseTypeRegistryName());
    }

    public static KnownTagManager<Pigment> pigmentTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.pigmentRegistryName());
    }

    public static KnownTagManager<Slurry> slurryTags() {
        return CraftTweakerTagRegistry.INSTANCE.knownTagManager(MekanismAPI.slurryRegistryName());
    }
}

