/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.chemical;

import java.util.function.Function;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.util.ChemicalUtil;

public abstract class BaseCrTChemicalStack<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CRT_STACK extends ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK>>
implements ICrTChemicalStack<CHEMICAL, STACK, CRT_STACK> {
    protected final STACK stack;
    protected final Function<STACK, CRT_STACK> stackConverter;

    public BaseCrTChemicalStack(STACK stack, Function<STACK, CRT_STACK> stackConverter) {
        this.stack = stack;
        this.stackConverter = stackConverter;
    }

    protected StringBuilder getBracket() {
        return new StringBuilder().append('<').append(this.getBracketName()).append(':').append(((ChemicalStack)this.stack).getTypeRegistryName()).append('>');
    }

    public String getCommandString() {
        StringBuilder builder = this.getBracket();
        if (!((ChemicalStack)this.stack).isEmpty() && ((ChemicalStack)this.stack).getAmount() != 1L) {
            builder.append(" * ").append(((ChemicalStack)this.stack).getAmount());
        }
        return builder.toString();
    }

    @Override
    public CRT_STACK copy() {
        return (CRT_STACK)((ICrTChemicalStack)this.stackConverter.apply(ChemicalUtil.copy(this.stack)));
    }

    @Override
    public STACK getInternal() {
        return this.stack;
    }

    public String toString() {
        return this.getCommandString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((ChemicalStack)this.stack).equals(((BaseCrTChemicalStack)o).stack);
    }

    public int hashCode() {
        return ((ChemicalStack)this.stack).hashCode();
    }
}

