/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.merged.ChemicalTankWrapper;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.FluidTankWrapper;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.capabilities.proxy.ProxyChemicalHandler;
import mekanism.common.entity.EntityRobit;
import mekanism.common.integration.lookingat.LookingAtHelper;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LookingAtUtils {
    private LookingAtUtils() {
    }

    @Nullable
    private static MultiblockData getMultiblock(@Nonnull BlockEntity tile) {
        if (tile instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)tile;
            return multiblock.getMultiblock();
        }
        if (tile instanceof IStructuralMultiblock) {
            IStructuralMultiblock multiblock = (IStructuralMultiblock)tile;
            for (Map.Entry<MultiblockManager<?>, Structure> entry : multiblock.getStructureMap().entrySet()) {
                Structure s;
                if (entry.getKey() == null || !(s = entry.getValue()).isValid()) continue;
                return s.getMultiblockData();
            }
        }
        return null;
    }

    public static void addInfo(LookingAtHelper info, @Nonnull Entity entity) {
        if (entity instanceof EntityRobit) {
            EntityRobit robit = (EntityRobit)entity;
            LookingAtUtils.displayEnergy(info, robit);
        }
    }

    public static void addInfo(LookingAtHelper info, @Nonnull BlockEntity tile, boolean displayTanks, boolean displayFluidTanks) {
        MultiblockData structure = LookingAtUtils.getMultiblock(tile);
        Optional energyCapability = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.STRICT_ENERGY_CAPABILITY, null).resolve();
        if (energyCapability.isPresent()) {
            LookingAtUtils.displayEnergy(info, (IStrictEnergyHandler)energyCapability.get());
        } else if (structure != null && structure.isFormed()) {
            LookingAtUtils.displayEnergy(info, structure);
        }
        if (displayTanks) {
            if (displayFluidTanks && tile instanceof TileEntityUpdateable) {
                Optional fluidCapability = CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).resolve();
                if (fluidCapability.isPresent()) {
                    LookingAtUtils.displayFluid(info, (IFluidHandler)fluidCapability.get());
                } else if (structure != null && structure.isFormed()) {
                    LookingAtUtils.displayFluid(info, structure);
                }
            }
            LookingAtUtils.addInfo(tile, structure, Capabilities.GAS_HANDLER_CAPABILITY, multiblock -> multiblock.getGasTanks(null), info, MekanismLang.GAS, MergedChemicalTank.Current.GAS, MergedTank.CurrentType.GAS);
            LookingAtUtils.addInfo(tile, structure, Capabilities.INFUSION_HANDLER_CAPABILITY, multiblock -> multiblock.getInfusionTanks(null), info, MekanismLang.INFUSE_TYPE, MergedChemicalTank.Current.INFUSION, MergedTank.CurrentType.INFUSION);
            LookingAtUtils.addInfo(tile, structure, Capabilities.PIGMENT_HANDLER_CAPABILITY, multiblock -> multiblock.getPigmentTanks(null), info, MekanismLang.PIGMENT, MergedChemicalTank.Current.PIGMENT, MergedTank.CurrentType.PIGMENT);
            LookingAtUtils.addInfo(tile, structure, Capabilities.SLURRY_HANDLER_CAPABILITY, multiblock -> multiblock.getSlurryTanks(null), info, MekanismLang.SLURRY, MergedChemicalTank.Current.SLURRY, MergedTank.CurrentType.SLURRY);
        }
    }

    private static void displayFluid(LookingAtHelper info, IFluidHandler fluidHandler) {
        if (fluidHandler instanceof IMekanismFluidHandler) {
            IMekanismFluidHandler mekFluidHandler = (IMekanismFluidHandler)fluidHandler;
            for (IExtendedFluidTank fluidTank : mekFluidHandler.getFluidTanks(null)) {
                FluidTankWrapper wrapper;
                MergedTank mergedTank;
                MergedTank.CurrentType currentType;
                if (fluidTank instanceof FluidTankWrapper && (currentType = (mergedTank = (wrapper = (FluidTankWrapper)fluidTank).getMergedTank()).getCurrentType()) != MergedTank.CurrentType.EMPTY && currentType != MergedTank.CurrentType.FLUID) continue;
                LookingAtUtils.addFluidInfo(info, fluidTank.getFluid(), fluidTank.getCapacity());
            }
        } else {
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                LookingAtUtils.addFluidInfo(info, fluidHandler.getFluidInTank(tank), fluidHandler.getTankCapacity(tank));
            }
        }
    }

    private static void addFluidInfo(LookingAtHelper info, FluidStack fluidInTank, int capacity) {
        if (!fluidInTank.isEmpty()) {
            info.addText((Component)MekanismLang.LIQUID.translate(fluidInTank));
        }
        info.addFluidElement(fluidInTank, capacity);
    }

    private static void displayEnergy(LookingAtHelper info, IStrictEnergyHandler energyHandler) {
        int containers = energyHandler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            info.addEnergyElement(energyHandler.getEnergy(container), energyHandler.getMaxEnergy(container));
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> void addInfo(BlockEntity tile, @Nullable MultiblockData structure, Capability<HANDLER> capability, Function<MultiblockData, List<TANK>> multiBlockToTanks, LookingAtHelper info, ILangEntry langEntry, MergedChemicalTank.Current matchingCurrent, MergedTank.CurrentType matchingCurrentType) {
        block8: {
            block7: {
                List tanks;
                Optional cap = CapabilityUtils.getCapability((ICapabilityProvider)tile, capability, null).resolve();
                if (!cap.isPresent()) break block7;
                IChemicalHandler handler = (IChemicalHandler)cap.get();
                if (handler instanceof ProxyChemicalHandler && !(tanks = ((ProxyChemicalHandler)handler).getTanksIfMekanism()).isEmpty()) {
                    for (IChemicalTank tank : tanks) {
                        LookingAtUtils.addChemicalTankInfo(info, langEntry, tank, matchingCurrent, matchingCurrentType);
                    }
                    return;
                }
                if (handler instanceof IMekanismChemicalHandler) {
                    IMekanismChemicalHandler mekHandler = (IMekanismChemicalHandler)handler;
                    for (IChemicalTank tank : mekHandler.getChemicalTanks(null)) {
                        LookingAtUtils.addChemicalTankInfo(info, langEntry, tank, matchingCurrent, matchingCurrentType);
                    }
                } else {
                    for (int i = 0; i < handler.getTanks(); ++i) {
                        LookingAtUtils.addChemicalInfo(info, langEntry, handler.getChemicalInTank(i), handler.getTankCapacity(i));
                    }
                }
                break block8;
            }
            if (structure == null || !structure.isFormed()) break block8;
            for (IChemicalTank tank : multiBlockToTanks.apply(structure)) {
                LookingAtUtils.addChemicalTankInfo(info, langEntry, tank, matchingCurrent, matchingCurrentType);
            }
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> void addChemicalTankInfo(LookingAtHelper info, ILangEntry langEntry, TANK chemicalTank, MergedChemicalTank.Current matchingCurrent, MergedTank.CurrentType matchingCurrentType) {
        MergedChemicalTank.Current current;
        MergedTank tank;
        MergedChemicalTank mergedTank;
        if (chemicalTank instanceof ChemicalTankWrapper && ((mergedTank = ((ChemicalTankWrapper)chemicalTank).getMergedTank()) instanceof MergedTank ? (tank = (MergedTank)mergedTank).getCurrentType() != matchingCurrentType : ((current = mergedTank.getCurrent()) == MergedChemicalTank.Current.EMPTY ? matchingCurrent != MergedChemicalTank.Current.GAS : current != matchingCurrent))) {
            return;
        }
        LookingAtUtils.addChemicalInfo(info, langEntry, chemicalTank.getStack(), chemicalTank.getCapacity());
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void addChemicalInfo(LookingAtHelper info, ILangEntry langEntry, STACK chemicalInTank, long capacity) {
        if (!chemicalInTank.isEmpty()) {
            info.addText((Component)langEntry.translate(chemicalInTank.getType()));
        }
        info.addChemicalElement(chemicalInTank, capacity);
    }
}

