/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.ISlurryProvider;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.tags.ITag;

public final class NSSSlurry
extends AbstractNSSTag<Slurry> {
    private NSSSlurry(@Nonnull ResourceLocation resourceLocation, boolean isTag) {
        super(resourceLocation, isTag);
    }

    @Nonnull
    public static NSSSlurry createSlurry(@Nonnull SlurryStack stack) {
        return NSSSlurry.createSlurry((Slurry)stack.getType());
    }

    @Nonnull
    public static NSSSlurry createSlurry(@Nonnull ISlurryProvider slurryProvider) {
        return NSSSlurry.createSlurry((Slurry)slurryProvider.getChemical());
    }

    @Nonnull
    public static NSSSlurry createSlurry(@Nonnull Slurry slurry) {
        if (slurry.isEmptyType()) {
            throw new IllegalArgumentException("Can't make NSSSlurry with an empty slurry");
        }
        return NSSSlurry.createSlurry(slurry.getRegistryName());
    }

    @Nonnull
    public static NSSSlurry createSlurry(@Nonnull ResourceLocation slurryID) {
        return new NSSSlurry(slurryID, false);
    }

    @Nonnull
    public static NSSSlurry createTag(@Nonnull ResourceLocation tagId) {
        return new NSSSlurry(tagId, true);
    }

    @Nonnull
    public static NSSSlurry createTag(@Nonnull TagKey<Slurry> tag) {
        return NSSSlurry.createTag(tag.f_203868_());
    }

    protected boolean isInstance(AbstractNSSTag o) {
        return o instanceof NSSSlurry;
    }

    @Nonnull
    public String getJsonPrefix() {
        return "SLURRY|";
    }

    @Nonnull
    public String getType() {
        return "Slurry";
    }

    @Nonnull
    protected Optional<Either<HolderSet.Named<Slurry>, ITag<Slurry>>> getTag() {
        return this.getTag(MekanismAPI.slurryRegistry());
    }

    protected Function<Slurry, NormalizedSimpleStack> createNew() {
        return NSSSlurry::createSlurry;
    }
}

