/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.ISecurityContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.ArmorSlot;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IHasExtraData;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.container.slot.OffhandSlot;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBlockPos;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloat;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.container.sync.SyncableRegistryEntry;
import mekanism.common.inventory.container.sync.SyncableShort;
import mekanism.common.inventory.container.sync.chemical.SyncableChemicalStack;
import mekanism.common.inventory.container.sync.chemical.SyncableGasStack;
import mekanism.common.inventory.container.sync.chemical.SyncableInfusionStack;
import mekanism.common.inventory.container.sync.chemical.SyncablePigmentStack;
import mekanism.common.inventory.container.sync.chemical.SyncableSlurryStack;
import mekanism.common.inventory.container.sync.list.SyncableList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.network.to_client.container.PacketUpdateContainer;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_server.PacketWindowSelect;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class MekanismContainer
extends AbstractContainerMenu
implements ISecurityContainer {
    public static final int BASE_Y_OFFSET = 84;
    public static final int TRANSPORTER_CONFIG_WINDOW = 0;
    public static final int SIDE_CONFIG_WINDOW = 1;
    public static final int UPGRADE_WINDOW = 2;
    public static final int SKIN_SELECT_WINDOW = 3;
    protected final Inventory inv;
    protected final List<InventoryContainerSlot> inventoryContainerSlots = new ArrayList<InventoryContainerSlot>();
    protected final List<ArmorSlot> armorSlots = new ArrayList<ArmorSlot>();
    protected final List<MainInventorySlot> mainInventorySlots = new ArrayList<MainInventorySlot>();
    protected final List<HotBarSlot> hotBarSlots = new ArrayList<HotBarSlot>();
    protected final List<OffhandSlot> offhandSlots = new ArrayList<OffhandSlot>();
    private final List<ISyncableData> trackedData = new ArrayList<ISyncableData>();
    private final Map<Object, List<ISyncableData>> specificTrackedData = new Object2ObjectOpenHashMap();
    @Nullable
    protected SelectedWindowData selectedWindow;
    private Map<UUID, SelectedWindowData> selectedWindows;

    protected MekanismContainer(ContainerTypeRegistryObject<?> type, int id, Inventory inv) {
        super((MenuType)type.get(), id);
        this.inv = inv;
        if (!this.isRemote()) {
            this.selectedWindows = new HashMap<UUID, SelectedWindowData>(1);
        }
    }

    public boolean isRemote() {
        return this.inv.f_35978_.f_19853_.f_46443_;
    }

    public UUID getPlayerUUID() {
        return this.inv.f_35978_.m_142081_();
    }

    @Nonnull
    protected Slot m_38897_(@Nonnull Slot slot) {
        super.m_38897_(slot);
        if (slot instanceof IHasExtraData) {
            IHasExtraData hasExtraData = (IHasExtraData)slot;
            hasExtraData.addTrackers(this.inv.f_35978_, this::track);
        }
        if (slot instanceof InventoryContainerSlot) {
            InventoryContainerSlot inventorySlot = (InventoryContainerSlot)slot;
            this.inventoryContainerSlots.add(inventorySlot);
        } else if (slot instanceof ArmorSlot) {
            ArmorSlot armorSlot = (ArmorSlot)slot;
            this.armorSlots.add(armorSlot);
        } else if (slot instanceof MainInventorySlot) {
            MainInventorySlot inventorySlot = (MainInventorySlot)slot;
            this.mainInventorySlots.add(inventorySlot);
        } else if (slot instanceof HotBarSlot) {
            HotBarSlot hotBarSlot = (HotBarSlot)slot;
            this.hotBarSlots.add(hotBarSlot);
        } else if (slot instanceof OffhandSlot) {
            OffhandSlot offhandSlot = (OffhandSlot)slot;
            this.offhandSlots.add(offhandSlot);
        }
        return slot;
    }

    protected void addSlotsAndOpen() {
        this.addSlots();
        this.addInventorySlots(this.inv);
        this.openInventory(this.inv);
    }

    public void startTracking(Object key, ISpecificContainerTracker tracker) {
        List<ISyncableData> list = tracker.getSpecificSyncableData();
        list.forEach(this::track);
        this.specificTrackedData.put(key, list);
    }

    public void stopTracking(Object key) {
        List<ISyncableData> list = this.specificTrackedData.get(key);
        if (list != null) {
            list.forEach(this.trackedData::remove);
            this.specificTrackedData.remove(key);
        }
    }

    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }

    public boolean m_5882_(@Nonnull ItemStack stack, @Nonnull Slot slot) {
        if (slot instanceof IInsertableSlot) {
            IInsertableSlot insertableSlot = (IInsertableSlot)slot;
            if (!insertableSlot.canMergeWith(stack)) {
                return false;
            }
            SelectedWindowData selectedWindow = this.isRemote() ? this.getSelectedWindow() : this.getSelectedWindow(this.getPlayerUUID());
            return insertableSlot.exists(selectedWindow) && super.m_5882_(stack, slot);
        }
        return super.m_5882_(stack, slot);
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.closeInventory(player);
    }

    protected void closeInventory(@Nonnull Player player) {
        if (!player.f_19853_.m_5776_()) {
            this.clearSelectedWindow(player.m_142081_());
        }
    }

    protected void openInventory(@Nonnull Inventory inv) {
    }

    protected int getInventoryYOffset() {
        return 84;
    }

    protected int getInventoryXOffset() {
        return 8;
    }

    protected void addInventorySlots(@Nonnull Inventory inv) {
        if (this instanceof IEmptyContainer) {
            return;
        }
        int yOffset = this.getInventoryYOffset();
        int xOffset = this.getInventoryXOffset();
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.m_38897_(new MainInventorySlot((Container)inv, Inventory.m_36059_() + slotX + slotY * 9, xOffset + slotX * 18, yOffset + slotY * 18));
            }
        }
        yOffset += 58;
        for (int slotX = 0; slotX < Inventory.m_36059_(); ++slotX) {
            this.m_38897_(this.createHotBarSlot(inv, slotX, xOffset + slotX * 18, yOffset));
        }
    }

    protected void addArmorSlots(@Nonnull Inventory inv, int x, int y, int offhandOffset) {
        for (int index = 0; index < inv.f_35975_.size(); ++index) {
            EquipmentSlot slotType = EnumUtils.EQUIPMENT_SLOT_TYPES[2 + inv.f_35975_.size() - index - 1];
            this.m_38897_(new ArmorSlot(inv, 36 + inv.f_35975_.size() - index - 1, x, y, slotType));
            y += 18;
        }
        if (offhandOffset != -1) {
            this.m_38897_(new OffhandSlot((Container)inv, 40, x, y + offhandOffset));
        }
    }

    protected HotBarSlot createHotBarSlot(@Nonnull Inventory inv, int index, int x, int y) {
        return new HotBarSlot((Container)inv, index, x, y);
    }

    protected void addSlots() {
    }

    public List<InventoryContainerSlot> getInventoryContainerSlots() {
        return Collections.unmodifiableList(this.inventoryContainerSlots);
    }

    public List<MainInventorySlot> getMainInventorySlots() {
        return Collections.unmodifiableList(this.mainInventorySlots);
    }

    public List<HotBarSlot> getHotBarSlots() {
        return Collections.unmodifiableList(this.hotBarSlots);
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slotID) {
        ItemStack slotStack;
        IInsertableSlot insertableSlot;
        SelectedWindowData selectedWindow;
        Slot currentSlot = (Slot)this.f_38839_.get(slotID);
        if (currentSlot == null || !currentSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        SelectedWindowData selectedWindowData = selectedWindow = player.f_19853_.f_46443_ ? this.getSelectedWindow() : this.getSelectedWindow(player.m_142081_());
        if (currentSlot instanceof IInsertableSlot && !(insertableSlot = (IInsertableSlot)currentSlot).exists(selectedWindow)) {
            return ItemStack.f_41583_;
        }
        ItemStack stackToInsert = slotStack = currentSlot.m_7993_();
        if (currentSlot instanceof InventoryContainerSlot) {
            stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, true, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, false, selectedWindow);
            stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, false, selectedWindow);
        } else {
            stackToInsert = MekanismContainer.insertItem(this.inventoryContainerSlots, stackToInsert, true, selectedWindow);
            if (slotStack.m_41613_() == stackToInsert.m_41613_()) {
                stackToInsert = MekanismContainer.insertItem(this.inventoryContainerSlots, stackToInsert, false, selectedWindow);
                if (slotStack.m_41613_() == stackToInsert.m_41613_()) {
                    if (currentSlot instanceof ArmorSlot || currentSlot instanceof OffhandSlot) {
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, true, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, true, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, false, selectedWindow);
                    } else if (currentSlot instanceof MainInventorySlot) {
                        stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.hotBarSlots, stackToInsert, selectedWindow);
                    } else if (currentSlot instanceof HotBarSlot) {
                        stackToInsert = MekanismContainer.insertItem(this.armorSlots, stackToInsert, false, selectedWindow);
                        stackToInsert = MekanismContainer.insertItem(this.mainInventorySlots, stackToInsert, selectedWindow);
                    }
                }
            }
        }
        if (stackToInsert.m_41613_() == slotStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return this.transferSuccess(currentSlot, player, slotStack, stackToInsert);
    }

    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, @Nullable SelectedWindowData selectedWindow) {
        stack = MekanismContainer.insertItem(slots, stack, true, selectedWindow);
        return MekanismContainer.insertItem(slots, stack, false, selectedWindow);
    }

    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty, @Nullable SelectedWindowData selectedWindow) {
        return MekanismContainer.insertItem(slots, stack, ignoreEmpty, selectedWindow, Action.EXECUTE);
    }

    @Nonnull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty, @Nullable SelectedWindowData selectedWindow, Action action) {
        return MekanismContainer.insertItem(slots, stack, ignoreEmpty, false, selectedWindow, action);
    }

    @Nonnull
    public static <SLOT extends Slot> ItemStack insertItemCheckAll(List<SLOT> slots, @Nonnull ItemStack stack, @Nullable SelectedWindowData selectedWindow, Action action) {
        return MekanismContainer.insertItem(slots, stack, false, true, selectedWindow, action);
    }

    @Nonnull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty, boolean checkAll, @Nullable SelectedWindowData selectedWindow, Action action) {
        if (stack.m_41619_()) {
            return stack;
        }
        for (Slot slot : slots) {
            if (!checkAll && ignoreEmpty != slot.m_6657_() || !((IInsertableSlot)slot).exists(selectedWindow) || !(stack = ((IInsertableSlot)slot).insertItem(stack, action)).m_41619_()) continue;
            break;
        }
        return stack;
    }

    @Nonnull
    protected ItemStack transferSuccess(@Nonnull Slot currentSlot, @Nonnull Player player, @Nonnull ItemStack slotStack, @Nonnull ItemStack stackToInsert) {
        int difference = slotStack.m_41613_() - stackToInsert.m_41613_();
        currentSlot.m_6201_(difference);
        ItemStack newStack = StackUtils.size(slotStack, difference);
        currentSlot.m_142406_(player, newStack);
        return newStack;
    }

    @Nullable
    public SelectedWindowData getSelectedWindow() {
        return this.selectedWindow;
    }

    @Nullable
    public SelectedWindowData getSelectedWindow(UUID player) {
        return this.selectedWindows.get(player);
    }

    public void setSelectedWindow(@Nullable SelectedWindowData selectedWindow) {
        if (!Objects.equals(this.selectedWindow, selectedWindow)) {
            this.selectedWindow = selectedWindow;
            Mekanism.packetHandler().sendToServer(new PacketWindowSelect(this.selectedWindow));
        }
    }

    public void setSelectedWindow(UUID player, @Nullable SelectedWindowData selectedWindow) {
        if (selectedWindow == null) {
            this.clearSelectedWindow(player);
        } else {
            this.selectedWindows.put(player, selectedWindow);
        }
    }

    private void clearSelectedWindow(UUID player) {
        this.selectedWindows.remove(player);
    }

    public void track(ISyncableData data) {
        this.trackedData.add(data);
    }

    @Nonnull
    protected DataSlot m_38895_(@Nonnull DataSlot referenceHolder) {
        this.track(SyncableInt.create(() -> ((DataSlot)referenceHolder).m_6501_(), arg_0 -> ((DataSlot)referenceHolder).m_6422_(arg_0)));
        return referenceHolder;
    }

    public void trackArray(boolean[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableBoolean.create(arrayIn, i));
        }
    }

    public void trackArray(byte[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableByte.create(arrayIn, i));
        }
    }

    public void trackArray(double[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableDouble.create(arrayIn, i));
        }
    }

    public void trackArray(float[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableFloat.create(arrayIn, i));
        }
    }

    public void trackArray(int[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableInt.create(arrayIn, i));
        }
    }

    public void trackArray(long[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableLong.create(arrayIn, i));
        }
    }

    public void trackArray(short[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableShort.create(arrayIn, i));
        }
    }

    public void handleWindowProperty(short property, boolean value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableBoolean) {
            SyncableBoolean syncable = (SyncableBoolean)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, byte value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableByte) {
            SyncableByte syncable = (SyncableByte)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, short value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableShort) {
            SyncableShort syncable = (SyncableShort)data;
            syncable.set(value);
        } else if (data instanceof SyncableFloatingLong) {
            SyncableFloatingLong syncable = (SyncableFloatingLong)data;
            syncable.setDecimal(value);
        }
    }

    public void handleWindowProperty(short property, int value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableInt) {
            SyncableInt syncable = (SyncableInt)data;
            syncable.set(value);
        } else if (data instanceof SyncableEnum) {
            SyncableEnum syncable = (SyncableEnum)data;
            syncable.set(value);
        } else if (data instanceof SyncableFluidStack) {
            SyncableFluidStack syncable = (SyncableFluidStack)data;
            syncable.set(value);
        } else if (data instanceof SyncableItemStack) {
            SyncableItemStack syncable = (SyncableItemStack)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, long value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableLong) {
            SyncableLong syncable = (SyncableLong)data;
            syncable.set(value);
        } else if (data instanceof SyncableChemicalStack) {
            SyncableChemicalStack syncable = (SyncableChemicalStack)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, float value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFloat) {
            SyncableFloat syncable = (SyncableFloat)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, double value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableDouble) {
            SyncableDouble syncable = (SyncableDouble)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull ItemStack value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableItemStack) {
            SyncableItemStack syncable = (SyncableItemStack)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull FluidStack value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFluidStack) {
            SyncableFluidStack syncable = (SyncableFluidStack)data;
            syncable.set(value);
        }
    }

    public void handleWindowProperty(short property, @Nullable BlockPos value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableBlockPos) {
            SyncableBlockPos syncable = (SyncableBlockPos)data;
            syncable.set(value);
        }
    }

    public <V extends IForgeRegistryEntry<V>> void handleWindowProperty(short property, @Nonnull V value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableRegistryEntry) {
            ((SyncableRegistryEntry)data).set(value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public <STACK extends ChemicalStack<?>> void handleWindowProperty(short property, @Nonnull STACK value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableGasStack) {
            SyncableGasStack syncable = (SyncableGasStack)data;
            if (value instanceof GasStack) {
                GasStack stack = (GasStack)value;
                syncable.set(stack);
                return;
            }
        }
        if (data instanceof SyncableInfusionStack) {
            SyncableInfusionStack syncable = (SyncableInfusionStack)data;
            if (value instanceof InfusionStack) {
                InfusionStack stack = (InfusionStack)value;
                syncable.set(stack);
                return;
            }
        }
        if (data instanceof SyncablePigmentStack) {
            SyncablePigmentStack syncable = (SyncablePigmentStack)data;
            if (value instanceof PigmentStack) {
                PigmentStack stack = (PigmentStack)value;
                syncable.set(stack);
                return;
            }
        }
        if (!(data instanceof SyncableSlurryStack)) return;
        SyncableSlurryStack syncable = (SyncableSlurryStack)data;
        if (!(value instanceof SlurryStack)) return;
        SlurryStack stack = (SlurryStack)value;
        syncable.set(stack);
    }

    public <FREQUENCY extends Frequency> void handleWindowProperty(short property, @Nullable FREQUENCY value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFrequency) {
            ((SyncableFrequency)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull FloatingLong value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFloatingLong) {
            SyncableFloatingLong syncable = (SyncableFloatingLong)data;
            syncable.set(value);
        }
    }

    public <TYPE> void handleWindowProperty(short property, @Nonnull List<TYPE> value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableList) {
            ((SyncableList)data).set(value);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        Player player = this.inv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ArrayList<PropertyData> dirtyData = new ArrayList<PropertyData>();
            for (short i = 0; i < this.trackedData.size(); i = (short)(i + 1)) {
                ISyncableData data = this.trackedData.get(i);
                ISyncableData.DirtyType dirtyType = data.isDirty();
                if (dirtyType == ISyncableData.DirtyType.CLEAN) continue;
                dirtyData.add(data.getPropertyData(i, dirtyType));
            }
            if (!dirtyData.isEmpty()) {
                Mekanism.packetHandler().sendTo(new PacketUpdateContainer((short)this.f_38840_, dirtyData), player2);
            }
        }
    }

    public void m_150429_() {
        super.m_150429_();
        Player player = this.inv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ArrayList<PropertyData> dirtyData = new ArrayList<PropertyData>();
            for (short i = 0; i < this.trackedData.size(); i = (short)(i + 1)) {
                dirtyData.add(this.trackedData.get(i).getPropertyData(i, ISyncableData.DirtyType.DIRTY));
            }
            if (!dirtyData.isEmpty()) {
                Mekanism.packetHandler().sendTo(new PacketUpdateContainer((short)this.f_38840_, dirtyData), player2);
            }
        }
    }

    public static interface ISpecificContainerTracker {
        public List<ISyncableData> getSpecificSyncableData();
    }
}

