/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.slot;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IHasExtraData;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VirtualCraftingOutputSlot
extends VirtualInventoryContainerSlot
implements IHasExtraData {
    @Nonnull
    private final QIOCraftingWindow craftingWindow;
    private boolean canCraft;
    private int amountCrafted;

    public VirtualCraftingOutputSlot(BasicInventorySlot slot, @Nullable SlotOverlay slotOverlay, Consumer<ItemStack> uncheckedSetter, @Nonnull QIOCraftingWindow craftingWindow) {
        super(slot, craftingWindow.getWindowData(), slotOverlay, uncheckedSetter);
        this.craftingWindow = craftingWindow;
    }

    @Override
    public boolean canMergeWith(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    public boolean m_5857_(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, Action action) {
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack m_6201_(int amount) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        IInventorySlot slot = this.getInventorySlot();
        ItemStack extracted = slot.extractItem(slot.getCount(), Action.SIMULATE, AutomationType.MANUAL);
        this.amountCrafted += extracted.m_41613_();
        return extracted;
    }

    protected void m_7169_(@Nonnull ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.m_5845_(stack);
    }

    protected void m_6405_(int numItemsCrafted) {
        this.amountCrafted += numItemsCrafted;
    }

    public void m_142406_(@Nonnull Player player, @Nonnull ItemStack stack) {
        ItemStack result = this.craftingWindow.performCraft(player, stack, this.amountCrafted);
        this.amountCrafted = 0;
    }

    @Override
    public boolean m_8010_(@Nonnull Player player) {
        if (player.f_19853_.f_46443_ || !(player instanceof ServerPlayer)) {
            return this.canCraft && super.m_8010_(player);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        return this.craftingWindow.canViewRecipe(serverPlayer) && super.m_8010_(player);
    }

    @Override
    @Nonnull
    public ItemStack getStackToRender() {
        return this.canCraft ? super.getStackToRender() : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack shiftClickSlot(@Nonnull Player player, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
        this.craftingWindow.performCraft(player, hotBarSlots, mainInventorySlots);
        return ItemStack.f_41583_;
    }

    @Override
    public void addTrackers(Player player, Consumer<ISyncableData> tracker) {
        if (player.f_19853_.f_46443_ || !(player instanceof ServerPlayer)) {
            tracker.accept(SyncableBoolean.create(() -> this.canCraft, value -> {
                this.canCraft = value;
            }));
        } else {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            tracker.accept(SyncableBoolean.create(() -> this.craftingWindow.canViewRecipe(serverPlayer), value -> {
                this.canCraft = value;
            }));
        }
    }
}

