/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.lib.security.IOwnerItem;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SecurityInventorySlot
extends BasicInventorySlot {
    private static final Predicate<@NonNull ItemStack> validator = stack -> stack.m_41720_() instanceof IOwnerItem;

    public static SecurityInventorySlot unlock(Supplier<UUID> ownerSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(ownerSupplier, "Owner supplier cannot be null");
        return new SecurityInventorySlot(stack -> ((IOwnerItem)stack.m_41720_()).getOwnerUUID((ItemStack)stack) == null, stack -> {
            UUID ownerUUID = ((IOwnerItem)stack.m_41720_()).getOwnerUUID((ItemStack)stack);
            return ownerUUID != null && ownerUUID.equals(ownerSupplier.get());
        }, listener, x, y);
    }

    public static SecurityInventorySlot lock(@Nullable IContentsListener listener, int x, int y) {
        return new SecurityInventorySlot(stack -> ((IOwnerItem)stack.m_41720_()).getOwnerUUID((ItemStack)stack) != null, stack -> ((IOwnerItem)stack.m_41720_()).getOwnerUUID((ItemStack)stack) == null, listener, x, y);
    }

    private SecurityInventorySlot(Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
    }

    public void unlock(UUID ownerUUID) {
        IOwnerItem item;
        UUID stackOwner;
        Item item2;
        if (!this.isEmpty() && (item2 = this.current.m_41720_()) instanceof IOwnerItem && (stackOwner = (item = (IOwnerItem)item2).getOwnerUUID(this.current)) != null && stackOwner.equals(ownerUUID)) {
            item.setOwnerUUID(this.current, null);
            if (item instanceof ISecurityItem) {
                ISecurityItem securityItem = (ISecurityItem)item;
                securityItem.setSecurity(this.current, SecurityMode.PUBLIC);
            }
        }
    }

    public void lock(UUID ownerUUID, SecurityFrequency frequency) {
        Item item;
        if (!this.isEmpty() && (item = this.current.m_41720_()) instanceof IOwnerItem) {
            IOwnerItem item2 = (IOwnerItem)item;
            UUID stackOwner = item2.getOwnerUUID(this.current);
            if (stackOwner == null) {
                stackOwner = ownerUUID;
                item2.setOwnerUUID(this.current, stackOwner);
            }
            if (stackOwner.equals(ownerUUID) && item2 instanceof ISecurityItem) {
                ISecurityItem securityItem = (ISecurityItem)item2;
                securityItem.setSecurity(this.current, frequency.getSecurityMode());
            }
        }
    }
}

