/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.machine;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.OwnerDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class ItemBlockMachine
extends ItemBlockTooltip<BlockTile<?, ?>>
implements IItemSustainedInventory,
ISecurityItem {
    public ItemBlockMachine(BlockTile<?, ?> block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().m_41487_(1));
    }

    @Override
    protected void addDetails(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        FluidStack fluidStack;
        tooltip.add(OwnerDisplay.of(MekanismUtils.tryGetClientPlayer(), this.getOwnerUUID(stack)).getTextComponent());
        if (Attribute.has(this.m_40614_(), Attributes.AttributeSecurity.class)) {
            ISecurityObject securityObject = SecurityUtils.wrapSecurityItem(stack);
            tooltip.add((Component)MekanismLang.SECURITY.translateColored(EnumColor.GRAY, SecurityUtils.getSecurity(securityObject, Dist.CLIENT)));
            if (SecurityUtils.isOverridden(securityObject, Dist.CLIENT)) {
                tooltip.add((Component)MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0]));
            }
        }
        this.addTypeDetails(stack, world, tooltip, flag);
        if (Attribute.has(this.m_40614_(), AttributeEnergy.class)) {
            StorageUtils.addStoredEnergy(stack, tooltip, false);
        }
        if (!(fluidStack = StorageUtils.getStoredFluidFromNBT(stack)).isEmpty()) {
            tooltip.add((Component)MekanismLang.GENERIC_STORED_MB.translateColored(EnumColor.PINK, fluidStack, EnumColor.GRAY, TextUtils.format(fluidStack.getAmount())));
        }
        if (Attribute.has(this.m_40614_(), Attributes.AttributeInventory.class)) {
            tooltip.add((Component)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))));
        }
        if (Attribute.has(this.m_40614_(), AttributeUpgradeSupport.class)) {
            MekanismUtils.addUpgradesToTooltip(stack, tooltip);
        }
    }

    protected void addTypeDetails(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (Attribute.has(this.m_40614_(), AttributeEnergy.class)) {
            AttributeEnergy attributeEnergy = Attribute.get(this.m_40614_(), AttributeEnergy.class);
            FloatingLongSupplier maxEnergy = Attribute.has(this.m_40614_(), AttributeUpgradeSupport.class) ? new UpgradeBasedFloatingLongCache(stack, attributeEnergy::getStorage) : attributeEnergy::getStorage;
            return new ItemCapabilityWrapper(stack, RateLimitEnergyHandler.create(maxEnergy, BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue));
        }
        return super.initCapabilities(stack, nbt);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (Attribute.has(this.m_40614_(), AttributeEnergy.class)) {
            return oldStack.m_41720_() != newStack.m_41720_();
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (Attribute.has(this.m_40614_(), AttributeEnergy.class)) {
            return oldStack.m_41720_() != newStack.m_41720_();
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    private static class UpgradeBasedFloatingLongCache
    implements FloatingLongSupplier {
        private final ItemStack stack;
        private final FloatingLongSupplier baseStorage;
        @Nullable
        private CompoundTag lastNBT;
        private FloatingLong value;

        private UpgradeBasedFloatingLongCache(ItemStack stack, FloatingLongSupplier baseStorage) {
            this.stack = stack;
            this.lastNBT = ItemDataUtils.hasData(stack, "componentUpgrade", 10) ? ItemDataUtils.getCompound(stack, "componentUpgrade").m_6426_() : null;
            this.baseStorage = baseStorage;
            this.value = MekanismUtils.getMaxEnergy(this.stack, this.baseStorage.get());
        }

        @Override
        @Nonnull
        public FloatingLong get() {
            if (ItemDataUtils.hasData(this.stack, "componentUpgrade", 10)) {
                CompoundTag upgrades = ItemDataUtils.getCompound(this.stack, "componentUpgrade");
                if (this.lastNBT == null || !this.lastNBT.equals((Object)upgrades)) {
                    this.lastNBT = upgrades.m_6426_();
                    this.value = MekanismUtils.getMaxEnergy(this.stack, this.baseStorage.get());
                }
            } else if (this.lastNBT != null) {
                this.lastNBT = null;
                this.value = MekanismUtils.getMaxEnergy(this.stack, this.baseStorage.get());
            }
            return this.value;
        }
    }
}

