/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IDisableableEnum;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.BlockBounding;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IRadialModeItem;
import mekanism.common.item.interfaces.IRadialSelectorEnum;
import mekanism.common.network.to_client.PacketLightningRender;
import mekanism.common.tags.MekanismTags;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ItemAtomicDisassembler
extends ItemEnergized
implements IItemHUDProvider,
IRadialModeItem<DisassemblerMode> {
    public static final Set<ToolAction> ALWAYS_SUPPORTED_ACTIONS = Set.of(ToolActions.AXE_DIG, ToolActions.HOE_DIG, ToolActions.SHOVEL_DIG, ToolActions.PICKAXE_DIG, ToolActions.SWORD_DIG);
    private final Multimap<Attribute, AttributeModifier> attributes;

    public ItemAtomicDisassembler(Item.Properties properties) {
        super(MekanismConfig.gear.disassemblerChargeRate, MekanismConfig.gear.disassemblerMaxEnergy, properties.m_41497_(Rarity.RARE).setNoRepair());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.attributes = builder.build();
    }

    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        consumer.accept(RenderPropertiesProvider.disassembler());
    }

    public boolean m_8096_(@Nonnull BlockState state) {
        return true;
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        DisassemblerMode mode = this.getMode(stack);
        tooltip.add((Component)MekanismLang.MODE.translateColored(EnumColor.INDIGO, mode));
        tooltip.add((Component)MekanismLang.DISASSEMBLER_EFFICIENCY.translateColored(EnumColor.INDIGO, mode.getEfficiency()));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return ALWAYS_SUPPORTED_ACTIONS.contains(action);
    }

    public boolean onLeftClickEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull Entity target) {
        if (target.m_6095_().m_204039_(MekanismTags.Entities.HURTABLE_VEHICLES) && target.m_6097_() && !target.m_7313_((Entity)player)) {
            target.m_6469_(DamageSource.m_19344_((Player)player), (float)MekanismConfig.gear.disassemblerMaxDamage.get());
        }
        return super.onLeftClickEntity(stack, player, target);
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        FloatingLong energy = energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
        FloatingLong energyCost = (FloatingLong)MekanismConfig.gear.disassemblerEnergyUsageWeapon.get();
        int minDamage = MekanismConfig.gear.disassemblerMinDamage.get();
        int damageDifference = MekanismConfig.gear.disassemblerMaxDamage.get() - minDamage;
        double percent = 1.0;
        if (energy.smallerThan(energyCost)) {
            percent = energy.divideToLevel(energyCost);
        }
        float damage = (float)((double)minDamage + (double)damageDifference * percent);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            target.m_6469_(DamageSource.m_19344_((Player)player), damage);
        } else {
            target.m_6469_(DamageSource.m_19370_((LivingEntity)attacker), damage);
        }
        if (energyContainer != null && !energy.isZero()) {
            energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer == null) {
            return 0.0f;
        }
        FloatingLong energyRequired = this.getDestroyEnergy(stack, state.f_60599_);
        FloatingLong energyAvailable = energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL);
        if (energyAvailable.smallerThan(energyRequired)) {
            return (float)DisassemblerMode.NORMAL.getEfficiency() * energyAvailable.divide(energyRequired).floatValue();
        }
        return this.getMode(stack).getEfficiency();
    }

    public boolean m_6813_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null) {
            energyContainer.extract(this.getDestroyEnergy(stack, state.m_60800_((BlockGetter)world, pos)), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.f_19853_.f_46443_ || player.m_7500_()) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
        if (energyContainer != null && this.getMode(stack) == DisassemblerMode.VEIN) {
            Level world = player.f_19853_;
            BlockState state = world.m_8055_(pos);
            FloatingLong baseDestroyEnergy = this.getDestroyEnergy(stack);
            FloatingLong energyRequired = this.getDestroyEnergy(baseDestroyEnergy, state.m_60800_((BlockGetter)world, pos));
            if (energyContainer.extract(energyRequired, Action.SIMULATE, AutomationType.MANUAL).greaterOrEqual(energyRequired) && !(state.m_60734_() instanceof BlockBounding) && state.m_204336_(MekanismTags.Blocks.ATOMIC_DISASSEMBLER_ORE)) {
                List<BlockPos> found = ItemAtomicDisassembler.findPositions(state, pos, world);
                MekanismUtils.veinMineArea(energyContainer, world, pos, (ServerPlayer)player, stack, this, found, hardness -> this.getDestroyEnergy(baseDestroyEnergy, hardness.floatValue()), distance -> 0.5 * Math.pow(distance, 1.5), state);
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    private static List<BlockPos> findPositions(BlockState state, BlockPos location, Level world) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        found.add(location);
        Block startBlock = state.m_60734_();
        int maxCount = MekanismConfig.gear.disassemblerMiningCount.get() - 1;
        for (int i = 0; i < found.size(); ++i) {
            BlockPos blockPos = (BlockPos)found.get(i);
            checked.add(blockPos);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)blockPos.m_142082_(-1, -1, -1), (BlockPos)blockPos.m_142082_(1, 1, 1))) {
                Optional<BlockState> blockState;
                if (checked.contains(pos) || !(blockState = WorldUtils.getBlockState((BlockGetter)world, pos)).isPresent() || startBlock != blockState.get().m_60734_()) continue;
                found.add(pos.m_7949_());
                Mekanism.packetHandler().sendToAllTracking(new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(blockPos, pos), Vec3.m_82512_((Vec3i)blockPos), Vec3.m_82512_((Vec3i)pos), 10), world, blockPos);
                if (found.size() <= maxCount) continue;
                return found;
            }
        }
        return found;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness) {
        return this.getDestroyEnergy(this.getDestroyEnergy(itemStack), hardness);
    }

    private FloatingLong getDestroyEnergy(FloatingLong baseDestroyEnergy, float hardness) {
        return hardness == 0.0f ? baseDestroyEnergy.divide(2L) : baseDestroyEnergy;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack) {
        return ((FloatingLong)MekanismConfig.gear.disassemblerEnergyUsage.get()).multiply(this.getMode(itemStack).getEfficiency());
    }

    @Override
    public DisassemblerMode getMode(ItemStack itemStack) {
        return DisassemblerMode.byIndexStatic(ItemDataUtils.getInt(itemStack, "mode"));
    }

    @Override
    public DisassemblerMode getModeByIndex(int ordinal) {
        return DisassemblerMode.byIndexStatic(ordinal);
    }

    @Override
    public void setMode(ItemStack stack, Player player, DisassemblerMode mode) {
        ItemDataUtils.setInt(stack, "mode", mode.ordinal());
    }

    @Override
    public Class<DisassemblerMode> getModeClass() {
        return DisassemblerMode.class;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, @Nonnull ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.attributes : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        DisassemblerMode mode = this.getMode(stack);
        list.add((Component)MekanismLang.MODE.translateColored(EnumColor.GRAY, EnumColor.INDIGO, mode));
        list.add((Component)MekanismLang.DISASSEMBLER_EFFICIENCY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, mode.getEfficiency()));
    }

    @Override
    public void changeMode(@Nonnull Player player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        DisassemblerMode newMode;
        DisassemblerMode mode = this.getMode(stack);
        if (mode != (newMode = (DisassemblerMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            if (displayChangeMessage) {
                player.m_6352_(MekanismUtils.logFormat(MekanismLang.DISASSEMBLER_MODE_CHANGE.translate(EnumColor.INDIGO, newMode, EnumColor.AQUA, newMode.getEfficiency())), Util.f_137441_);
            }
        }
    }

    @Override
    @Nonnull
    public Component getScrollTextComponent(@Nonnull ItemStack stack) {
        DisassemblerMode mode = this.getMode(stack);
        return MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(EnumColor.INDIGO, mode, EnumColor.AQUA, mode.getEfficiency());
    }

    public int getDefaultTooltipHideFlags(@Nonnull ItemStack stack) {
        return super.getDefaultTooltipHideFlags(stack) | ItemStack.TooltipPart.MODIFIERS.m_41809_();
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public static enum DisassemblerMode implements IDisableableEnum<DisassemblerMode>,
    IRadialSelectorEnum<DisassemblerMode>,
    IHasTextComponent
    {
        NORMAL(MekanismLang.DISASSEMBLER_NORMAL, 20, () -> true, EnumColor.BRIGHT_GREEN, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "disassembler_normal.png")),
        SLOW(MekanismLang.DISASSEMBLER_SLOW, 8, MekanismConfig.gear.disassemblerSlowMode, EnumColor.BRIGHT_GREEN, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "disassembler_slow.png")),
        FAST(MekanismLang.DISASSEMBLER_FAST, 128, MekanismConfig.gear.disassemblerFastMode, EnumColor.BRIGHT_GREEN, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "disassembler_fast.png")),
        VEIN(MekanismLang.DISASSEMBLER_VEIN, 20, MekanismConfig.gear.disassemblerVeinMining, EnumColor.BRIGHT_GREEN, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "disassembler_vein.png")),
        OFF(MekanismLang.DISASSEMBLER_OFF, 0, () -> true, EnumColor.BRIGHT_GREEN, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "void.png"));

        private static final DisassemblerMode[] MODES;
        private final BooleanSupplier checkEnabled;
        private final ILangEntry langEntry;
        private final int efficiency;
        private final EnumColor color;
        private final ResourceLocation icon;

        private DisassemblerMode(ILangEntry langEntry, int efficiency, BooleanSupplier checkEnabled, EnumColor color, ResourceLocation icon) {
            this.langEntry = langEntry;
            this.efficiency = efficiency;
            this.checkEnabled = checkEnabled;
            this.color = color;
            this.icon = icon;
        }

        public static DisassemblerMode byIndexStatic(int index) {
            DisassemblerMode mode = MathUtils.getByIndexMod(MODES, index);
            return mode.isEnabled() ? mode : NORMAL;
        }

        @Override
        @Nonnull
        public DisassemblerMode byIndex(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate(this.color);
        }

        @Override
        public Component getShortText() {
            return this.getTextComponent();
        }

        public int getEfficiency() {
            return this.efficiency;
        }

        @Override
        public boolean isEnabled() {
            return this.checkEnabled.getAsBoolean();
        }

        @Override
        public ResourceLocation getIcon() {
            return this.icon;
        }

        @Override
        public EnumColor getColor() {
            return this.color;
        }

        static {
            MODES = DisassemblerMode.values();
        }
    }
}

