/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.world.item.ItemStack;

public interface IGasItem {
    @Nonnull
    default public GasStack useGas(ItemStack stack, long amount) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
        if (capability.isPresent()) {
            IGasHandler.IMekanismGasHandler gasHandler;
            IGasTank gasTank;
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            if (gasHandlerItem instanceof IGasHandler.IMekanismGasHandler && (gasTank = (IGasTank)(gasHandler = (IGasHandler.IMekanismGasHandler)gasHandlerItem).getChemicalTank(0, null)) != null) {
                return (GasStack)gasTank.extract(amount, Action.EXECUTE, AutomationType.MANUAL);
            }
            return (GasStack)gasHandlerItem.extractChemical(amount, Action.EXECUTE);
        }
        return GasStack.EMPTY;
    }
}

