/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class SidedBlockPos {
    private final BlockPos pos;
    private final Direction side;

    public static SidedBlockPos get(TransporterPathfinder.Destination destination) {
        List<BlockPos> path = destination.getPath();
        BlockPos pos = path.get(0);
        Direction sideOfDest = WorldUtils.sideDifference(path.get(1), pos);
        return new SidedBlockPos(pos, sideOfDest);
    }

    @Nullable
    public static SidedBlockPos deserialize(CompoundTag tag) {
        if (tag.m_128425_("x", 3) && tag.m_128425_("y", 3) && tag.m_128425_("z", 3) && tag.m_128425_("side", 3)) {
            BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
            Direction side = Direction.m_122376_((int)tag.m_128451_("side"));
            return new SidedBlockPos(pos, side);
        }
        return null;
    }

    public SidedBlockPos(BlockPos pos, Direction side) {
        this.pos = pos.m_7949_();
        this.side = side;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public CompoundTag serialize() {
        CompoundTag target = new CompoundTag();
        target.m_128405_("x", this.pos.m_123341_());
        target.m_128405_("y", this.pos.m_123342_());
        target.m_128405_("z", this.pos.m_123343_());
        target.m_128405_("side", this.side.ordinal());
        return target;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidedBlockPos that = (SidedBlockPos)o;
        return this.pos.equals((Object)that.pos) && this.side == that.side;
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.side);
    }
}

