/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.Collection;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public interface IValveHandler {
    default public void writeValves(CompoundTag updateTag) {
        ListTag valves = new ListTag();
        for (ValveData valveData : this.getValveData()) {
            if (valveData.activeTicks <= 0) continue;
            CompoundTag valveNBT = new CompoundTag();
            valveNBT.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)valveData.location));
            valveNBT.m_128405_("side", valveData.side.ordinal());
            valves.add((Object)valveNBT);
        }
        updateTag.m_128365_("valve", (Tag)valves);
    }

    default public void readValves(CompoundTag updateTag) {
        this.getValveData().clear();
        if (updateTag.m_128425_("valve", 9)) {
            ListTag valves = updateTag.m_128437_("valve", 10);
            for (int i = 0; i < valves.size(); ++i) {
                CompoundTag valveNBT = valves.m_128728_(i);
                ValveData data = new ValveData();
                NBTUtils.setBlockPosIfPresent(valveNBT, "position", pos -> {
                    data.location = pos;
                });
                data.side = Direction.m_122376_((int)valveNBT.m_128451_("side"));
                this.getValveData().add(data);
            }
        }
    }

    default public void triggerValveTransfer(IMultiblock<?> multiblock) {
        if (((MultiblockData)multiblock.getMultiblock()).isFormed()) {
            for (ValveData data : this.getValveData()) {
                if (!multiblock.getTilePos().equals((Object)data.location)) continue;
                data.onTransfer();
                break;
            }
        }
    }

    public Collection<ValveData> getValveData();

    public static class ValveData {
        public Direction side;
        public BlockPos location;
        public boolean prevActive;
        public int activeTicks;

        public void onTransfer() {
            this.activeTicks = 30;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.side.ordinal();
            code = 31 * code + this.location.hashCode();
            return code;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof ValveData)) return false;
            ValveData other = (ValveData)obj;
            if (other.side != this.side) return false;
            if (!other.location.equals((Object)this.location)) return false;
            return true;
        }
    }
}

