/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import net.minecraft.network.chat.Component;

public enum SecurityMode implements IIncrementalEnum<SecurityMode>,
IHasTextComponent
{
    PUBLIC(MekanismLang.PUBLIC, EnumColor.BRIGHT_GREEN),
    PRIVATE(MekanismLang.PRIVATE, EnumColor.RED),
    TRUSTED(MekanismLang.TRUSTED, EnumColor.INDIGO);

    private static final SecurityMode[] MODES;
    private final ILangEntry langEntry;
    private final EnumColor color;

    private SecurityMode(ILangEntry langEntry, EnumColor color) {
        this.langEntry = langEntry;
        this.color = color;
    }

    @Override
    public Component getTextComponent() {
        return this.langEntry.translateColored(this.color, new Object[0]);
    }

    @Override
    @Nonnull
    public SecurityMode byIndex(int index) {
        return SecurityMode.byIndexStatic(index);
    }

    public static SecurityMode byIndexStatic(int index) {
        return MathUtils.getByIndexMod(MODES, index);
    }

    static {
        MODES = SecurityMode.values();
    }
}

