/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.container.property.list;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_client.container.property.PropertyType;
import mekanism.common.network.to_client.container.property.list.FilterListPropertyData;
import mekanism.common.network.to_client.container.property.list.FrequencyListPropertyData;
import mekanism.common.network.to_client.container.property.list.ListType;
import mekanism.common.network.to_client.container.property.list.RegistryEntryListPropertyData;
import mekanism.common.network.to_client.container.property.list.StringListPropertyData;
import net.minecraft.network.FriendlyByteBuf;

public abstract class ListPropertyData<TYPE>
extends PropertyData {
    @Nonnull
    protected final List<TYPE> values;
    private final ListType listType;

    public ListPropertyData(short property, ListType listType, @Nonnull List<TYPE> values) {
        super(PropertyType.LIST, property);
        this.listType = listType;
        this.values = values;
    }

    public static <TYPE> ListPropertyData<TYPE> readList(short property, FriendlyByteBuf buffer) {
        ListType listType = (ListType)buffer.m_130066_(ListType.class);
        int elements = buffer.m_130242_();
        switch (listType) {
            case STRING: {
                return StringListPropertyData.read(property, elements, buffer);
            }
            case FILTER: {
                return FilterListPropertyData.read(property, elements, buffer);
            }
            case FREQUENCY: {
                return FrequencyListPropertyData.read(property, elements, buffer);
            }
            case REGISTRY_ENTRY: {
                return RegistryEntryListPropertyData.read(property, elements, buffer);
            }
        }
        Mekanism.logger.error("Unrecognized list type received: {}", (Object)listType);
        return null;
    }

    @Override
    public void handleWindowProperty(MekanismContainer container) {
        container.handleWindowProperty(this.getProperty(), this.values);
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.m_130068_((Enum)this.listType);
        buffer.m_130130_(this.values.size());
        for (TYPE value : this.values) {
            this.writeListElement(buffer, value);
        }
    }

    protected abstract void writeListElement(FriendlyByteBuf var1, TYPE var2);
}

