/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.common.recipe.WrappedShapedRecipe;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.registries.MekanismRecipeSerializers;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MekanismShapedRecipe
extends WrappedShapedRecipe {
    public MekanismShapedRecipe(ShapedRecipe internal) {
        super(internal);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MekanismRecipeSerializers.MEK_DATA.get();
    }

    @Override
    public ItemStack assemble(CraftingContainer inv) {
        if (this.m_8043_().m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack toReturn = this.m_8043_().m_41777_();
        ArrayList<ItemStack> nbtInputs = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41782_()) continue;
            nbtInputs.add(stack);
        }
        if (nbtInputs.isEmpty()) {
            return toReturn;
        }
        Set<RecipeUpgradeType> supportedTypes = RecipeUpgradeData.getSupportedTypes(toReturn);
        if (supportedTypes.isEmpty()) {
            return toReturn;
        }
        EnumMap<RecipeUpgradeType, List> upgradeInfo = new EnumMap<RecipeUpgradeType, List>(RecipeUpgradeType.class);
        for (ItemStack itemStack : nbtInputs) {
            Set<RecipeUpgradeType> stackSupportedTypes = RecipeUpgradeData.getSupportedTypes(itemStack);
            for (RecipeUpgradeType supportedType : stackSupportedTypes) {
                RecipeUpgradeData<?> data;
                if (!supportedTypes.contains((Object)supportedType) || (data = RecipeUpgradeData.getUpgradeData(supportedType, itemStack)) == null) continue;
                upgradeInfo.computeIfAbsent(supportedType, type -> new ArrayList()).add(data);
            }
        }
        for (Map.Entry entry : upgradeInfo.entrySet()) {
            Object data;
            List upgradeData = (List)entry.getValue();
            if (upgradeData.isEmpty() || (data = RecipeUpgradeData.mergeUpgradeData(upgradeData)) != null && data.applyToStack(toReturn)) continue;
            return ItemStack.f_41583_;
        }
        return toReturn;
    }
}

