/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class QIORecipeData
implements RecipeUpgradeData<QIORecipeData> {
    private final Object2LongMap<HashedItem> itemMap;
    private final long itemCount;

    QIORecipeData(IQIODriveItem.DriveMetadata data, ListTag nbtItemMap) {
        this.itemCount = data.count();
        this.itemMap = new Object2LongOpenHashMap(data.types());
        for (int i = 0; i < nbtItemMap.size(); ++i) {
            CompoundTag tag = nbtItemMap.m_128728_(i);
            ItemStack itemType = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
            this.itemMap.put((Object)HashedItem.create(itemType), tag.m_128454_("amount"));
        }
    }

    private QIORecipeData(Object2LongMap<HashedItem> itemMap, long itemCount) {
        this.itemMap = itemMap;
        this.itemCount = itemCount;
    }

    @Override
    @Nullable
    public QIORecipeData merge(QIORecipeData other) {
        if (this.itemCount <= Long.MAX_VALUE - other.itemCount) {
            Object2LongOpenHashMap fullItemMap = new Object2LongOpenHashMap();
            fullItemMap.putAll(this.itemMap);
            for (Object2LongMap.Entry entry : other.itemMap.object2LongEntrySet()) {
                HashedItem type = (HashedItem)entry.getKey();
                fullItemMap.put((Object)type, fullItemMap.getOrDefault((Object)type, 0L) + entry.getLongValue());
            }
            return new QIORecipeData((Object2LongMap<HashedItem>)fullItemMap, this.itemCount + other.itemCount);
        }
        return null;
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        IQIODriveItem driveItem = (IQIODriveItem)stack.m_41720_();
        if (this.itemCount > driveItem.getCountCapacity(stack) || this.itemMap.size() > driveItem.getTypeCapacity(stack)) {
            return false;
        }
        ListTag list = new ListTag();
        for (Object2LongMap.Entry entry : this.itemMap.object2LongEntrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Item", (Tag)((HashedItem)entry.getKey()).getStack().m_41739_(new CompoundTag()));
            tag.m_128356_("amount", entry.getLongValue());
            list.add((Object)tag);
        }
        ItemDataUtils.setList(stack, "qioItemMap", list);
        IQIODriveItem.DriveMetadata meta = new IQIODriveItem.DriveMetadata(this.itemCount, this.itemMap.size());
        meta.write(stack);
        return true;
    }
}

