/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade.chemical;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ChemicalRecipeData<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>>
implements RecipeUpgradeData<ChemicalRecipeData<CHEMICAL, STACK, TANK, HANDLER>> {
    protected final List<TANK> tanks;

    protected ChemicalRecipeData(ListTag tanks) {
        int count = DataHandlerUtils.getMaxId(tanks, "Tank");
        this.tanks = new ArrayList<TANK>(count);
        for (int i = 0; i < count; ++i) {
            this.tanks.add(this.getTankBuilder().createDummy(Long.MAX_VALUE));
        }
        DataHandlerUtils.readContainers(this.tanks, tanks);
    }

    protected ChemicalRecipeData(List<TANK> tanks) {
        this.tanks = tanks;
    }

    @Override
    @Nullable
    public ChemicalRecipeData<CHEMICAL, STACK, TANK, HANDLER> merge(ChemicalRecipeData<CHEMICAL, STACK, TANK, HANDLER> other) {
        ArrayList<TANK> allTanks = new ArrayList<TANK>(this.tanks.size() + other.tanks.size());
        allTanks.addAll(this.tanks);
        allTanks.addAll(other.tanks);
        return this.create(allTanks);
    }

    protected abstract ChemicalRecipeData<CHEMICAL, STACK, TANK, HANDLER> create(List<TANK> var1);

    protected abstract SubstanceType getSubstanceType();

    protected abstract ChemicalTankBuilder<CHEMICAL, STACK, TANK> getTankBuilder();

    protected abstract HANDLER getOutputHandler(List<TANK> var1);

    protected abstract Capability<HANDLER> getCapability();

    protected abstract Predicate<@NonNull CHEMICAL> cloneValidator(HANDLER var1, int var2);

    protected abstract HANDLER getHandlerFromTile(TileEntityMekanism var1);

    @Override
    public boolean applyToStack(ItemStack stack) {
        IChemicalHandler handler;
        if (this.tanks.isEmpty()) {
            return true;
        }
        Optional capability = stack.getCapability(this.getCapability()).resolve();
        if (capability.isPresent()) {
            handler = (IChemicalHandler)capability.get();
        } else {
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                IHasTileEntity hasTileEntity;
                Object tileEntity;
                BlockItem blockItem = (BlockItem)item;
                TileEntityMekanism tile = null;
                Block block = blockItem.m_40614_();
                if (block instanceof IHasTileEntity && (tileEntity = (hasTileEntity = (IHasTileEntity)block).createDummyBlockEntity()) instanceof TileEntityMekanism) {
                    tile = (TileEntityMekanism)tileEntity;
                }
                if (tile == null || !tile.handles(this.getSubstanceType())) {
                    return false;
                }
                handler = this.getHandlerFromTile(tile);
            } else {
                return false;
            }
        }
        int tankCount = handler.getTanks();
        if (tankCount == 0) {
            return true;
        }
        ArrayList<TANK> tanks = new ArrayList<TANK>();
        for (int tank = 0; tank < tankCount; ++tank) {
            tanks.add(this.getTankBuilder().create(handler.getTankCapacity(tank), this.cloneValidator(handler, tank), null));
        }
        HANDLER outputHandler = this.getOutputHandler(tanks);
        boolean hasData = false;
        for (IChemicalTank tank : this.tanks) {
            if (tank.isEmpty()) continue;
            if (!((ChemicalStack)outputHandler.insertChemical(tank.getStack(), Action.EXECUTE)).isEmpty()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            ItemDataUtils.setList(stack, this.getSubstanceType().getContainerTag(), DataHandlerUtils.writeContainers(tanks));
        }
        return true;
    }
}

