/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.IContentsListener;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.ISecurityContainer;
import mekanism.common.inventory.slot.SecurityInventorySlot;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.to_client.PacketSecurityUpdate;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TileEntitySecurityDesk
extends TileEntityMekanism
implements IBoundingBlock {
    public UUID ownerUUID;
    public String clientOwner;
    private SecurityInventorySlot unlockSlot;
    private SecurityInventorySlot lockSlot;

    public TileEntitySecurityDesk(BlockPos pos, BlockState state) {
        super(MekanismBlocks.SECURITY_DESK, pos, state);
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.unlockSlot = SecurityInventorySlot.unlock(() -> this.ownerUUID, listener, 146, 18);
        builder.addSlot(this.unlockSlot);
        this.lockSlot = SecurityInventorySlot.lock(listener, 146, 97);
        builder.addSlot(this.lockSlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        SecurityFrequency frequency = this.getFreq();
        if (this.ownerUUID != null && frequency != null) {
            this.unlockSlot.unlock(this.ownerUUID);
            this.lockSlot.lock(this.ownerUUID, frequency);
        }
    }

    public void toggleOverride() {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            frequency.setOverridden(!frequency.isOverridden());
            this.markForSave();
            Mekanism.packetHandler().sendToAll(new PacketSecurityUpdate(frequency.getOwner(), new SecurityData(frequency)));
            this.validateAccess();
        }
    }

    private void validateAccess() {
        MinecraftServer server;
        if (this.m_58898_() && (server = this.getWorldNN().m_142572_()) != null) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                ISecurityContainer container;
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (!(abstractContainerMenu instanceof ISecurityContainer) || SecurityUtils.canAccess((Player)player, (container = (ISecurityContainer)abstractContainerMenu).getSecurityObject())) continue;
                player.m_6915_();
            }
        }
    }

    public void removeTrusted(int index) {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            frequency.removeTrusted(index);
            this.markForSave();
        }
    }

    public void setSecurityDeskMode(SecurityMode mode) {
        SecurityMode old;
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null && (old = frequency.getSecurityMode()) != mode) {
            frequency.setSecurityMode(mode);
            this.markForSave();
            Mekanism.packetHandler().sendToAll(new PacketSecurityUpdate(frequency.getOwner(), new SecurityData(frequency)));
            if (old == SecurityMode.PUBLIC || old == SecurityMode.TRUSTED && mode == SecurityMode.PRIVATE) {
                this.validateAccess();
            }
        }
    }

    public void addTrusted(String name) {
        SecurityFrequency frequency = this.getFreq();
        if (frequency != null) {
            ServerLifecycleHooks.getCurrentServer().m_129927_().m_10996_(name).ifPresent(profile -> {
                frequency.addTrusted(profile.getId(), profile.getName());
                this.markForSave();
            });
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        NBTUtils.setUUIDIfPresent(nbt, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        if (this.ownerUUID != null) {
            nbtTags.m_128362_("owner", this.ownerUUID);
        }
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        if (this.ownerUUID != null) {
            updateTag.m_128362_("owner", this.ownerUUID);
            updateTag.m_128359_("ownerName", MekanismUtils.getLastKnownUsername(this.ownerUUID));
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setUUIDIfPresent(tag, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        NBTUtils.setStringIfPresent(tag, "ownerName", uuid -> {
            this.clientOwner = uuid;
        });
    }

    public SecurityFrequency getFreq() {
        return (SecurityFrequency)this.getFrequency(FrequencyType.SECURITY);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@Nonnull Capability<?> capability, Direction side, @Nonnull Vec3i offset) {
        return true;
    }
}

