/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.Coord4D;
import mekanism.api.IContentsListener;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TileEntityTeleporter
extends TileEntityMekanism
implements IChunkLoader {
    public final Set<UUID> didTeleport = new ObjectOpenHashSet();
    private AABB teleportBounds;
    public int teleDelay = 0;
    public boolean shouldRender;
    @Nullable
    private Direction frameDirection;
    private boolean frameRotated;
    private EnumColor color;
    public byte status = 0;
    private final TileComponentChunkLoader<TileEntityTeleporter> chunkLoaderComponent = new TileComponentChunkLoader<TileEntityTeleporter>(this);
    private MachineEnergyContainer<TileEntityTeleporter> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityTeleporter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.TELEPORTER, pos, state);
        this.frequencyComponent.track(FrequencyType.TELEPORTER, true, true, false);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.cacheCoord();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityTeleporter)this).m_58904_(), listener, 153, 7);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    public static void alignPlayer(ServerPlayer player, BlockPos target, TileEntityTeleporter teleporter) {
        Direction side = null;
        if (teleporter.frameDirection != null && teleporter.frameDirection.m_122434_().m_122479_()) {
            side = teleporter.frameDirection;
        } else {
            for (Direction iterSide : MekanismUtils.SIDE_DIRS) {
                if (!player.f_19853_.m_46859_(target.m_142300_(iterSide))) continue;
                side = iterSide;
                break;
            }
        }
        float yaw = player.m_146908_();
        if (side != null) {
            switch (side) {
                case NORTH: {
                    yaw = 180.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 0.0f;
                    break;
                }
                case WEST: {
                    yaw = 90.0f;
                    break;
                }
                case EAST: {
                    yaw = 270.0f;
                }
            }
        }
        player.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), yaw, player.m_146909_());
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.teleportBounds == null && this.frameDirection != null) {
            this.resetBounds();
        }
        this.status = this.canTeleport();
        if (MekanismUtils.canFunction(this) && this.status == 1 && this.teleDelay == 0) {
            this.teleport();
        }
        if (this.teleDelay == 0 && this.teleportBounds != null && !this.didTeleport.isEmpty()) {
            this.cleanTeleportCache();
        }
        boolean prevShouldRender = this.shouldRender;
        this.shouldRender = this.status == 1 || this.status > 4;
        EnumColor prevColor = this.color;
        TeleporterFrequency freq = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        EnumColor enumColor = this.color = freq != null ? freq.getColor() : null;
        if (this.shouldRender != prevShouldRender) {
            WorldUtils.notifyLoadedNeighborsOfTileChange(this.f_58857_, this.m_58899_());
            this.sendUpdatePacket();
        } else if (this.color != prevColor) {
            this.sendUpdatePacket();
        }
        this.teleDelay = Math.max(0, this.teleDelay - 1);
        this.energySlot.fillContainerOrConvert();
    }

    @Nullable
    private Coord4D getClosest() {
        TeleporterFrequency frequency = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        return frequency == null ? null : frequency.getClosestCoords(this.getTileCoord());
    }

    private void cleanTeleportCache() {
        List<UUID> inTeleporter = this.f_58857_.m_45976_(Entity.class, this.teleportBounds).stream().map(Entity::m_142081_).toList();
        if (inTeleporter.isEmpty()) {
            this.didTeleport.clear();
        } else {
            this.didTeleport.removeIf(id -> !inTeleporter.contains(id));
        }
    }

    private void resetBounds() {
        this.teleportBounds = this.frameDirection == null ? null : this.getTeleporterBoundingBox(this.frameDirection);
    }

    private byte canTeleport() {
        Coord4D closestCoords;
        Direction direction = this.getFrameDirection();
        if (direction == null) {
            this.frameDirection = null;
            return 2;
        }
        if (this.frameDirection != direction) {
            this.frameDirection = direction;
            this.resetBounds();
        }
        if ((closestCoords = this.getClosest()) == null) {
            return 3;
        }
        FloatingLong sum = FloatingLong.ZERO;
        for (Entity entity : this.getToTeleport(this.f_58857_.m_46472_() == closestCoords.dimension)) {
            sum = sum.plusEqual(TileEntityTeleporter.calculateEnergyCost(entity, closestCoords));
        }
        if (this.energyContainer.extract(sum, Action.SIMULATE, AutomationType.INTERNAL).smallerThan(sum)) {
            return 4;
        }
        return 1;
    }

    public BlockPos getTeleporterTargetPos() {
        if (this.frameDirection == null) {
            return this.f_58858_.m_7494_();
        }
        if (this.frameDirection == Direction.DOWN) {
            return this.f_58858_.m_6625_(2);
        }
        return this.f_58858_.m_142300_(this.frameDirection);
    }

    public void sendTeleportParticles() {
        BlockPos teleporterTargetPos = this.getTeleporterTargetPos();
        Direction offsetDirection = this.frameDirection == null || this.frameDirection.m_122434_().m_122478_() ? Direction.UP : this.frameDirection;
        Mekanism.packetHandler().sendToAllTracking(new PacketPortalFX(teleporterTargetPos, offsetDirection), this.f_58857_, teleporterTargetPos);
    }

    private void teleport() {
        boolean sameDimension;
        List<Entity> entitiesToTeleport;
        BlockPos closestPos;
        Coord4D closestCoords = this.getClosest();
        if (closestCoords == null || this.f_58857_ == null) {
            return;
        }
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        ServerLevel teleWorld = currentServer.m_129880_(closestCoords.dimension);
        TileEntityTeleporter teleporter = WorldUtils.getTileEntity(TileEntityTeleporter.class, (BlockGetter)teleWorld, closestPos = closestCoords.getPos());
        if (teleporter != null && !(entitiesToTeleport = this.getToTeleport(sameDimension = this.f_58857_.m_46472_() == closestCoords.dimension)).isEmpty()) {
            Set<Coord4D> activeCoords = ((TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER)).getActiveCoords();
            BlockPos teleporterTargetPos = teleporter.getTeleporterTargetPos();
            for (Entity entity : entitiesToTeleport) {
                this.markTeleported(teleporter, entity, sameDimension);
                teleporter.teleDelay = 5;
                FloatingLong energyCost = TileEntityTeleporter.calculateEnergyCost(entity, closestCoords);
                double oldX = entity.m_20185_();
                double oldY = entity.m_20186_();
                double oldZ = entity.m_20189_();
                Entity teleportedEntity = TileEntityTeleporter.teleportEntityTo(entity, (Level)teleWorld, teleporterTargetPos);
                if (teleportedEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)teleportedEntity;
                    TileEntityTeleporter.alignPlayer(player, teleporterTargetPos, teleporter);
                }
                for (Coord4D coords : activeCoords) {
                    Object world = this.f_58857_.m_46472_() == coords.dimension ? this.f_58857_ : currentServer.m_129880_(coords.dimension);
                    TileEntityTeleporter tile = WorldUtils.getTileEntity(TileEntityTeleporter.class, (BlockGetter)world, coords.getPos());
                    if (tile == null) continue;
                    tile.sendTeleportParticles();
                }
                this.energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.INTERNAL);
                if (teleportedEntity == null) continue;
                if (this.f_58857_ != teleportedEntity.f_19853_ || teleportedEntity.m_20275_(oldX, oldY, oldZ) >= 25.0) {
                    this.f_58857_.m_6263_(null, oldX, oldY, oldZ, SoundEvents.f_11852_, entity.m_5720_(), 1.0f, 1.0f);
                }
                teleportedEntity.f_19853_.m_6263_(null, teleportedEntity.m_20185_(), teleportedEntity.m_20186_(), teleportedEntity.m_20189_(), SoundEvents.f_11852_, teleportedEntity.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    private void markTeleported(TileEntityTeleporter teleporter, Entity entity, boolean sameDimension) {
        if (sameDimension || entity.m_6072_()) {
            teleporter.didTeleport.add(entity.m_142081_());
            for (Entity passenger : entity.m_20197_()) {
                this.markTeleported(teleporter, passenger, sameDimension);
            }
        }
    }

    @Nullable
    public static Entity teleportEntityTo(Entity entity, Level targetWorld, BlockPos target) {
        if (entity.m_20193_().m_46472_() == targetWorld.m_46472_()) {
            entity.m_6021_((double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5);
            if (!entity.m_20197_().isEmpty()) {
                ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, (Packet)new ClientboundSetPassengersPacket(entity));
                Entity controller = entity.m_6688_();
                if (controller != entity && controller instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)controller;
                    if (!(controller instanceof FakePlayer) && player.f_8906_ != null) {
                        player.f_8906_.m_141995_((Packet)new ClientboundMoveVehiclePacket(entity));
                    }
                }
            }
            return entity;
        }
        final Vec3 destination = new Vec3((double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5);
        final List passengers = entity.m_20197_();
        return entity.changeDimension((ServerLevel)targetWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedEntity = repositionEntity.apply(false);
                if (repositionedEntity != null) {
                    for (Entity passenger : passengers) {
                        TileEntityTeleporter.teleportPassenger(destWorld, destination, repositionedEntity, passenger);
                    }
                }
                return repositionedEntity;
            }

            public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                return new PortalInfo(destination, entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
            }

            public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                return false;
            }
        });
    }

    private static void teleportPassenger(ServerLevel destWorld, final Vec3 destination, final Entity repositionedEntity, Entity passenger) {
        if (!passenger.m_6072_()) {
            return;
        }
        final List passengers = passenger.m_20197_();
        passenger.changeDimension(destWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                boolean invulnerable = entity.m_20147_();
                entity.m_20331_(true);
                Entity repositionedPassenger = repositionEntity.apply(false);
                if (repositionedPassenger != null) {
                    repositionedPassenger.m_7998_(repositionedEntity, true);
                    for (Entity passenger : passengers) {
                        TileEntityTeleporter.teleportPassenger(destWorld, destination, repositionedPassenger, passenger);
                    }
                    repositionedPassenger.m_20331_(invulnerable);
                }
                entity.m_20331_(invulnerable);
                return repositionedPassenger;
            }

            public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                return new PortalInfo(destination, entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
            }

            public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                return false;
            }
        });
    }

    private List<Entity> getToTeleport(boolean sameDimension) {
        return this.f_58857_ == null || this.teleportBounds == null ? Collections.emptyList() : this.f_58857_.m_6443_(Entity.class, this.teleportBounds, entity -> !entity.m_5833_() && !entity.m_20159_() && !(entity instanceof PartEntity) && (sameDimension || entity.m_6072_()) && !this.didTeleport.contains(entity.m_142081_()));
    }

    @Nonnull
    public static FloatingLong calculateEnergyCost(Entity entity, Coord4D coords) {
        FloatingLong energyCost = (FloatingLong)MekanismConfig.usage.teleporterBase.get();
        energyCost = entity.f_19853_.m_46472_() == coords.dimension ? energyCost.add(((FloatingLong)MekanismConfig.usage.teleporterDistance.get()).multiply(Math.sqrt(entity.m_20275_((double)coords.getX(), (double)coords.getY(), (double)coords.getZ())))) : energyCost.add((FloatingLong)MekanismConfig.usage.teleporterDimensionPenalty.get());
        HashSet<Entity> passengers = new HashSet<Entity>();
        TileEntityTeleporter.fillIndirectPassengers(entity, entity.f_19853_.m_46472_() == coords.dimension, passengers);
        int passengerCount = passengers.size();
        return passengerCount > 0 ? energyCost.multiply(passengerCount) : energyCost;
    }

    private static void fillIndirectPassengers(Entity base, boolean sameDimension, Set<Entity> passengers) {
        for (Entity entity : base.m_20197_()) {
            if (!sameDimension && !entity.m_6072_()) continue;
            passengers.add(entity);
            TileEntityTeleporter.fillIndirectPassengers(entity, sameDimension, passengers);
        }
    }

    @Nullable
    private Direction getFrameDirection() {
        for (Direction direction : EnumUtils.DIRECTIONS) {
            if (this.hasFrame(direction, false)) {
                this.frameRotated = false;
                return direction;
            }
            if (!this.hasFrame(direction, true)) continue;
            this.frameRotated = true;
            return direction;
        }
        return null;
    }

    private boolean hasFrame(Direction direction, boolean rotated) {
        int alternatingX = 0;
        int alternatingY = 0;
        int alternatingZ = 0;
        if (rotated) {
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                alternatingX = 1;
            } else {
                alternatingZ = 1;
            }
        } else if (direction == Direction.UP || direction == Direction.DOWN) {
            alternatingX = 1;
        } else {
            alternatingY = 1;
        }
        int xComponent = direction.m_122429_();
        int yComponent = direction.m_122430_();
        int zComponent = direction.m_122431_();
        Long2ObjectArrayMap chunkMap = new Long2ObjectArrayMap(3);
        return this.isFramePair((Long2ObjectMap<ChunkAccess>)chunkMap, 0, alternatingX, 0, alternatingY, 0, alternatingZ) && this.isFramePair((Long2ObjectMap<ChunkAccess>)chunkMap, xComponent, alternatingX, yComponent, alternatingY, zComponent, alternatingZ) && this.isFramePair((Long2ObjectMap<ChunkAccess>)chunkMap, 2 * xComponent, alternatingX, 2 * yComponent, alternatingY, 2 * zComponent, alternatingZ) && this.isFramePair((Long2ObjectMap<ChunkAccess>)chunkMap, 3 * xComponent, alternatingX, 3 * yComponent, alternatingY, 3 * zComponent, alternatingZ) && this.isFrame((Long2ObjectMap<ChunkAccess>)chunkMap, 3 * xComponent, 3 * yComponent, 3 * zComponent);
    }

    private boolean isFramePair(Long2ObjectMap<ChunkAccess> chunkMap, int xOffset, int alternatingX, int yOffset, int alternatingY, int zOffset, int alternatingZ) {
        return this.isFrame(chunkMap, xOffset - alternatingX, yOffset - alternatingY, zOffset - alternatingZ) && this.isFrame(chunkMap, xOffset + alternatingX, yOffset + alternatingY, zOffset + alternatingZ);
    }

    private boolean isFrame(Long2ObjectMap<ChunkAccess> chunkMap, int xOffset, int yOffset, int zOffset) {
        Optional<BlockState> state = WorldUtils.getBlockState((LevelAccessor)this.f_58857_, chunkMap, this.f_58858_.m_142082_(xOffset, yOffset, zOffset));
        return state.filter(blockState -> blockState.m_60713_(MekanismBlocks.TELEPORTER_FRAME.getBlock())).isPresent();
    }

    @Nullable
    public Direction frameDirection() {
        if (this.frameDirection == null) {
            return this.getFrameDirection();
        }
        return this.frameDirection;
    }

    public boolean frameRotated() {
        return this.frameRotated;
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        Direction frameDirection = this.getFrameDirection();
        return frameDirection == null ? new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1)) : this.getTeleporterBoundingBox(frameDirection);
    }

    private AABB getTeleporterBoundingBox(@Nonnull Direction frameDirection) {
        return switch (frameDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_142082_(1, 3, 1));
            case Direction.DOWN -> new AABB(this.f_58858_, this.f_58858_.m_142082_(1, -2, 1));
            case Direction.EAST -> new AABB(this.f_58858_.m_142126_(), this.f_58858_.m_142082_(3, 1, 1));
            case Direction.WEST -> new AABB(this.f_58858_, this.f_58858_.m_142082_(-2, 1, 1));
            case Direction.NORTH -> new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, -2));
            case Direction.SOUTH -> new AABB(this.f_58858_.m_142128_(), this.f_58858_.m_142082_(1, 1, 3));
        };
    }

    public TileComponentChunkLoader<TileEntityTeleporter> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        return Collections.singleton(new ChunkPos(this.m_58899_()));
    }

    @Override
    public int getRedstoneLevel() {
        return this.shouldRender ? 15 : 0;
    }

    @Override
    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return false;
    }

    @Override
    public int getCurrentRedstoneLevel() {
        return this.getRedstoneLevel();
    }

    public MachineEnergyContainer<TileEntityTeleporter> getEnergyContainer() {
        return this.energyContainer;
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableByte.create(() -> this.status, value -> {
            this.status = value;
        }));
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128379_("rendering", this.shouldRender);
        if (this.color != null) {
            updateTag.m_128405_("color", this.color.ordinal());
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setBooleanIfPresent(tag, "rendering", value -> {
            this.shouldRender = value;
        });
        this.color = tag.m_128425_("color", 3) ? EnumColor.byIndexStatic(tag.m_128451_("color")) : null;
    }

    @ComputerMethod
    private Collection<TeleporterFrequency> getFrequencies() {
        return FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequencies();
    }

    @ComputerMethod
    private boolean hasFrequency() {
        TeleporterFrequency frequency = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        return frequency != null && frequency.isValid();
    }

    @ComputerMethod
    private TeleporterFrequency getFrequency() throws ComputerException {
        TeleporterFrequency frequency = (TeleporterFrequency)this.getFrequency(FrequencyType.TELEPORTER);
        if (frequency == null || !frequency.isValid()) {
            throw new ComputerException("No frequency is currently selected.");
        }
        return frequency;
    }

    @ComputerMethod
    private void setFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency == null) {
            throw new ComputerException("No public teleporter frequency with name '%s' found.", name);
        }
        this.setFrequency(FrequencyType.TELEPORTER, frequency.getIdentity(), this.getOwnerUUID());
    }

    @ComputerMethod
    private void createFrequency(String name) throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = FrequencyType.TELEPORTER.getManagerWrapper().getPublicManager().getFrequency(name);
        if (frequency != null) {
            throw new ComputerException("Unable to create public teleporter frequency with name '%s' as one already exists.", name);
        }
        this.setFrequency(FrequencyType.TELEPORTER, new Frequency.FrequencyIdentity(name, true), this.getOwnerUUID());
    }

    @ComputerMethod
    private EnumColor getFrequencyColor() throws ComputerException {
        return this.getFrequency().getColor();
    }

    @ComputerMethod
    private void setFrequencyColor(EnumColor color) throws ComputerException {
        this.validateSecurityIsPublic();
        this.getFrequency().setColor(color);
    }

    @ComputerMethod
    private void incrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = this.getFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getNext());
    }

    @ComputerMethod
    private void decrementFrequencyColor() throws ComputerException {
        this.validateSecurityIsPublic();
        TeleporterFrequency frequency = this.getFrequency();
        frequency.setColor((EnumColor)frequency.getColor().getPrevious());
    }

    @ComputerMethod
    private Set<Coord4D> getActiveTeleporters() throws ComputerException {
        return this.getFrequency().getActiveCoords();
    }

    @ComputerMethod
    private String getStatus() {
        if (this.hasFrequency()) {
            return switch (this.status) {
                case 1 -> "ready";
                case 2 -> "no frame";
                case 4 -> "needs energy";
                default -> "no link";
            };
        }
        return "no frequency";
    }
}

