/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.UUID;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class TileComponentSecurity
implements ITileComponent {
    public final TileEntityMekanism tile;
    private UUID ownerUUID;
    private String ownerName;
    private SecurityMode securityMode = SecurityMode.PUBLIC;

    public TileComponentSecurity(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
        tile.getFrequencyComponent().track(FrequencyType.SECURITY, true, false, true);
    }

    public SecurityFrequency getFrequency() {
        return (SecurityFrequency)this.tile.getFrequency(FrequencyType.SECURITY);
    }

    @ComputerMethod
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.tile.getFrequencyComponent().setFrequency(FrequencyType.SECURITY, null);
        this.ownerUUID = uuid;
    }

    @ComputerMethod
    public String getOwnerName() {
        return this.ownerName;
    }

    @ComputerMethod(nameOverride="getSecurityMode")
    public SecurityMode getMode() {
        if (MekanismConfig.general.allowProtection.get()) {
            return this.securityMode;
        }
        return SecurityMode.PUBLIC;
    }

    public void setMode(SecurityMode mode) {
        if (this.securityMode != mode) {
            SecurityMode old = this.securityMode;
            this.securityMode = mode;
            this.tile.markForSave();
            this.tile.onSecurityChanged(old, this.securityMode);
        }
    }

    public void tickServer() {
        if (this.getFrequency() == null && this.ownerUUID != null) {
            this.tile.setFrequency(FrequencyType.SECURITY, new Frequency.FrequencyIdentity(this.ownerUUID, true), this.ownerUUID);
        }
    }

    @Override
    public void read(CompoundTag nbtTags) {
        if (nbtTags.m_128425_("componentSecurity", 10)) {
            CompoundTag securityNBT = nbtTags.m_128469_("componentSecurity");
            NBTUtils.setEnumIfPresent(securityNBT, "securityMode", SecurityMode::byIndexStatic, mode -> {
                this.securityMode = mode;
            });
            NBTUtils.setUUIDIfPresent(securityNBT, "owner", uuid -> {
                this.ownerUUID = uuid;
            });
        }
    }

    @Override
    public void write(CompoundTag nbtTags) {
        CompoundTag securityNBT = new CompoundTag();
        securityNBT.m_128405_("securityMode", this.securityMode.ordinal());
        if (this.ownerUUID != null) {
            securityNBT.m_128362_("owner", this.ownerUUID);
        }
        nbtTags.m_128365_("componentSecurity", (Tag)securityNBT);
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        container.track(SyncableEnum.create(SecurityMode::byIndexStatic, SecurityMode.PUBLIC, this::getMode, this::setMode));
    }

    @Override
    public void addToUpdateTag(CompoundTag updateTag) {
        if (this.ownerUUID != null) {
            updateTag.m_128362_("owner", this.ownerUUID);
            updateTag.m_128359_("ownerName", MekanismUtils.getLastKnownUsername(this.ownerUUID));
        }
    }

    @Override
    public void readFromUpdateTag(CompoundTag updateTag) {
        NBTUtils.setUUIDIfPresent(updateTag, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        NBTUtils.setStringIfPresent(updateTag, "ownerName", uuid -> {
            this.ownerName = uuid;
        });
    }
}

