/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.DataHandlerUtils;
import mekanism.api.Upgrade;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.UpgradeInventorySlot;
import mekanism.common.item.interfaces.IUpgradeItem;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TileComponentUpgrade
implements ITileComponent,
MekanismContainer.ISpecificContainerTracker {
    private static final int UPGRADE_TICKS_REQUIRED = 20;
    private int upgradeTicks;
    private final TileEntityMekanism tile;
    @SyntheticComputerMethod(getter="getInstalledUpgrades")
    private Map<Upgrade, Integer> upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
    private final Set<Upgrade> supported = EnumSet.noneOf(Upgrade.class);
    private final UpgradeInventorySlot upgradeSlot;
    private final UpgradeInventorySlot upgradeOutputSlot;

    public TileComponentUpgrade(TileEntityMekanism tile) {
        this.tile = tile;
        tile.getSupportedUpgrade().forEach(this::setSupported);
        this.upgradeSlot = UpgradeInventorySlot.input(tile, this.supported);
        this.upgradeOutputSlot = UpgradeInventorySlot.output(tile);
        tile.addComponent(this);
    }

    public void tickServer() {
        IUpgradeItem upgradeItem;
        Upgrade type;
        Item item;
        ItemStack stack = this.upgradeSlot.getStack();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IUpgradeItem && this.supports(type = (upgradeItem = (IUpgradeItem)item).getUpgradeType(stack)) && this.getUpgrades(type) < type.getMax()) {
            int added;
            if (this.upgradeTicks < 20) {
                ++this.upgradeTicks;
                return;
            }
            if (this.upgradeTicks == 20 && (added = this.addUpgrades(type, this.upgradeSlot.getCount())) > 0) {
                MekanismUtils.logMismatchedStackSize(this.upgradeSlot.shrinkStack(added, Action.EXECUTE), added);
            }
        }
        this.upgradeTicks = 0;
    }

    public UpgradeInventorySlot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    public UpgradeInventorySlot getUpgradeOutputSlot() {
        return this.upgradeOutputSlot;
    }

    public double getScaledUpgradeProgress() {
        return (double)this.upgradeTicks / 20.0;
    }

    public int getUpgrades(Upgrade upgrade) {
        return this.upgrades.getOrDefault(upgrade, 0);
    }

    public int addUpgrades(Upgrade upgrade, int maxAvailable) {
        int toAdd;
        int installed = this.getUpgrades(upgrade);
        if (installed < upgrade.getMax() && (toAdd = Math.min(upgrade.getMax() - installed, maxAvailable)) > 0) {
            this.upgrades.put(upgrade, installed + toAdd);
            this.tile.recalculateUpgrades(upgrade);
            if (upgrade == Upgrade.MUFFLING) {
                this.tile.sendUpdatePacket();
            }
            this.tile.markForSave();
            return toAdd;
        }
        return 0;
    }

    public void removeUpgrade(Upgrade upgrade, boolean removeAll) {
        int toRemove;
        ItemStack simulatedRemainder;
        int installed = this.getUpgrades(upgrade);
        if (installed > 0 && (simulatedRemainder = this.upgradeOutputSlot.insertItem(UpgradeUtils.getStack(upgrade, toRemove = removeAll ? installed : 1), Action.SIMULATE, AutomationType.INTERNAL)).m_41613_() < toRemove) {
            if (installed == (toRemove -= simulatedRemainder.m_41613_())) {
                this.upgrades.remove(upgrade);
            } else {
                this.upgrades.put(upgrade, installed - toRemove);
            }
            this.tile.recalculateUpgrades(upgrade);
            this.upgradeOutputSlot.insertItem(UpgradeUtils.getStack(upgrade, toRemove), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public void setSupported(Upgrade upgrade) {
        this.setSupported(upgrade, true);
    }

    public void setSupported(Upgrade upgrade, boolean isSupported) {
        if (isSupported) {
            this.supported.add(upgrade);
        } else {
            this.supported.remove(upgrade);
        }
    }

    public boolean supports(Upgrade upgrade) {
        return this.supported.contains(upgrade);
    }

    public boolean isUpgradeInstalled(Upgrade upgrade) {
        return this.upgrades.containsKey(upgrade);
    }

    public Set<Upgrade> getInstalledTypes() {
        return this.upgrades.keySet();
    }

    @ComputerMethod(nameOverride="getSupportedUpgrades")
    public Set<Upgrade> getSupportedTypes() {
        return this.supported;
    }

    private List<IInventorySlot> getSlots() {
        return List.of(this.upgradeSlot, this.upgradeOutputSlot);
    }

    @Override
    public void read(CompoundTag nbtTags) {
        if (nbtTags.m_128425_("componentUpgrade", 10)) {
            CompoundTag upgradeNBT = nbtTags.m_128469_("componentUpgrade");
            this.upgrades = Upgrade.buildMap(upgradeNBT);
            for (Upgrade upgrade : this.getSupportedTypes()) {
                this.tile.recalculateUpgrades(upgrade);
            }
            NBTUtils.setListIfPresent(upgradeNBT, "Items", 10, list -> DataHandlerUtils.readContainers(this.getSlots(), list));
        }
    }

    @Override
    public void write(CompoundTag nbtTags) {
        CompoundTag upgradeNBT = new CompoundTag();
        Upgrade.saveMap(this.upgrades, upgradeNBT);
        upgradeNBT.m_128365_("Items", (Tag)DataHandlerUtils.writeContainers(this.getSlots()));
        nbtTags.m_128365_("componentUpgrade", (Tag)upgradeNBT);
    }

    @Override
    public void addToUpdateTag(CompoundTag updateTag) {
        if (this.supports(Upgrade.MUFFLING)) {
            updateTag.m_128405_("muffling", this.upgrades.getOrDefault(Upgrade.MUFFLING, 0).intValue());
        }
    }

    @Override
    public void readFromUpdateTag(CompoundTag updateTag) {
        if (this.supports(Upgrade.MUFFLING)) {
            NBTUtils.setIntIfPresent(updateTag, "muffling", amount -> {
                if (amount == 0) {
                    this.upgrades.remove(Upgrade.MUFFLING);
                } else {
                    this.upgrades.put(Upgrade.MUFFLING, amount);
                }
            });
        }
    }

    @Override
    public List<ISyncableData> getSpecificSyncableData() {
        ArrayList<ISyncableData> list = new ArrayList<ISyncableData>();
        list.add(SyncableInt.create(() -> this.upgradeTicks, value -> {
            this.upgradeTicks = value;
        }));
        for (Upgrade upgrade : EnumUtils.UPGRADES) {
            if (!this.supports(upgrade)) continue;
            list.add(SyncableInt.create(() -> this.upgrades.getOrDefault(upgrade, 0), value -> {
                if (value == 0) {
                    this.upgrades.remove(upgrade);
                } else if (value > 0) {
                    this.upgrades.put(upgrade, value);
                }
            }));
        }
        return list;
    }
}

