/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IAlloyInteraction;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.DynamicHandler;
import mekanism.common.capabilities.proxy.ProxyConfigurable;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.BasicSidedCapabilityResolver;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class TileEntityTransmitter
extends CapabilityTileEntity
implements ProxyConfigurable.ISidedConfigurable,
IAlloyInteraction {
    public static final ModelProperty<TransmitterModelData> TRANSMITTER_PROPERTY = new ModelProperty();
    private final Transmitter<?, ?, ?> transmitter;
    private boolean forceUpdate = true;
    private boolean loaded = false;

    public TileEntityTransmitter(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(((IHasTileEntity)blockProvider.getBlock()).getTileType(), pos, state);
        this.transmitter = this.createTransmitter(blockProvider);
        this.cacheCoord();
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.ALLOY_INTERACTION_CAPABILITY, this));
        this.addCapabilityResolver(new BasicSidedCapabilityResolver<IConfigurable, TileEntityTransmitter>(this, Capabilities.CONFIGURABLE_CAPABILITY, ProxyConfigurable::new));
    }

    protected abstract Transmitter<?, ?, ?> createTransmitter(IBlockProvider var1);

    public Transmitter<?, ?, ?> getTransmitter() {
        return this.transmitter;
    }

    public void setForceUpdate() {
        this.forceUpdate = true;
    }

    public abstract TransmitterType getTransmitterType();

    protected void onUpdateServer() {
        if (this.forceUpdate) {
            this.getTransmitter().refreshConnections();
            this.forceUpdate = false;
        }
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, TileEntityTransmitter transmitter) {
        transmitter.onUpdateServer();
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        return this.getTransmitter().getReducedUpdateTag(super.getReducedUpdateTag());
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.getTransmitter().handleUpdateTag(tag);
    }

    @Override
    public void handleUpdatePacket(@Nonnull CompoundTag tag) {
        super.handleUpdatePacket(tag);
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.m_58904_(), this.m_58899_(), this.m_58900_());
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.getTransmitter().read(nbt);
    }

    public void m_183515_(@Nonnull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        this.getTransmitter().write(nbtTags);
    }

    public void onNeighborTileChange(Direction side) {
        this.getTransmitter().onNeighborTileChange(side);
    }

    public void onNeighborBlockChange(Direction side) {
        this.getTransmitter().onNeighborBlockChange(side);
    }

    public void m_6339_() {
        super.m_6339_();
        this.onWorldJoin();
    }

    public void m_7651_() {
        if (!this.isRemote()) {
            this.getTransmitter().takeShare();
        }
        super.m_7651_();
        this.onWorldSeparate();
        this.getTransmitter().remove();
    }

    public void onAdded() {
        this.onWorldJoin();
        this.getTransmitter().refreshConnections();
    }

    private void onWorldJoin() {
        this.loaded = true;
        if (!this.isRemote()) {
            TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
        }
    }

    private void onWorldSeparate() {
        this.loaded = false;
        if (this.isRemote()) {
            this.getTransmitter().setTransmitterNetwork(null);
        } else {
            TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Direction getSideLookingAt(Player player, Direction fallback) {
        Direction side = this.getSideLookingAt(player);
        return side == null ? fallback : side;
    }

    @Nullable
    public Direction getSideLookingAt(Player player) {
        MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace((Entity)player, this.m_58899_(), this.getCollisionBoxes());
        if (result != null && result.valid()) {
            ArrayList<Direction> list = new ArrayList<Direction>(EnumUtils.DIRECTIONS.length);
            byte connections = this.getTransmitter().getAllCurrentConnections();
            for (Direction dir : EnumUtils.DIRECTIONS) {
                if (!Transmitter.connectionMapContainsSide(connections, dir)) continue;
                list.add(dir);
            }
            int boxIndex = result.subHit + 1;
            if (boxIndex < list.size()) {
                return (Direction)list.get(boxIndex);
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public InteractionResult onSneakRightClick(@Nonnull Player player, @Nonnull Direction side) {
        if (!this.isRemote()) {
            Direction hitSide = this.getSideLookingAt(player);
            if (hitSide == null) {
                InteractionResult result;
                if (this.transmitter.getConnectionTypeRaw(side) != ConnectionType.NONE && (result = this.onConfigure(player, side)).m_19077_()) {
                    this.getTransmitter().refreshConnections();
                    this.getTransmitter().notifyTileChange();
                    return result;
                }
                hitSide = side;
            }
            this.transmitter.setConnectionTypeRaw(hitSide, (ConnectionType)this.transmitter.getConnectionTypeRaw(hitSide).getNext());
            this.getTransmitter().onModeChange(Direction.m_122376_((int)hitSide.ordinal()));
            this.getTransmitter().refreshConnections();
            this.getTransmitter().notifyTileChange();
            player.m_6352_((Component)MekanismLang.CONNECTION_TYPE.translate(this.transmitter.getConnectionTypeRaw(hitSide)), Util.f_137441_);
            this.sendUpdatePacket();
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult onConfigure(Player player, Direction side) {
        return this.getTransmitter().onConfigure(player, side);
    }

    @Override
    @Nonnull
    public InteractionResult onRightClick(@Nonnull Player player, @Nonnull Direction side) {
        return this.getTransmitter().onRightClick(player, side);
    }

    public List<VoxelShape> getCollisionBoxes() {
        ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
        boolean isSmall = this.getTransmitterType().getSize() == TransmitterType.Size.SMALL;
        for (Direction side : EnumUtils.DIRECTIONS) {
            ConnectionType connectionType = this.getTransmitter().getConnectionType(side);
            if (connectionType == ConnectionType.NONE) continue;
            if (isSmall) {
                list.add(BlockSmallTransmitter.getSideForType(connectionType, side));
                continue;
            }
            list.add(BlockLargeTransmitter.getSideForType(connectionType, side));
        }
        list.add(isSmall ? BlockSmallTransmitter.center : BlockLargeTransmitter.center);
        return list;
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1));
    }

    @Nonnull
    public IModelData getModelData() {
        TransmitterModelData data = this.initModelData();
        this.updateModelData(data);
        return new ModelDataMap.Builder().withInitial(TRANSMITTER_PROPERTY, (Object)data).build();
    }

    protected void updateModelData(TransmitterModelData modelData) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            modelData.setConnectionData(side, this.getTransmitter().getConnectionType(side));
        }
    }

    @Nonnull
    protected TransmitterModelData initModelData() {
        return new TransmitterModelData();
    }

    @Override
    public void onAlloyInteraction(Player player, ItemStack stack, @Nonnull AlloyTier tier) {
        if (this.m_58904_() != null && this.getTransmitter().hasTransmitterNetwork()) {
            Object transmitterNetwork = this.getTransmitter().getTransmitterNetwork();
            ArrayList list = new ArrayList(((DynamicNetwork)transmitterNetwork).getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    return Double.compare(o1.getTilePos().m_123331_((Vec3i)this.f_58858_), o2.getTilePos().m_123331_((Vec3i)this.f_58858_));
                }
                return 0;
            });
            boolean sharesSet = false;
            int upgraded = 0;
            for (Transmitter transmitter : list) {
                BlockState upgradeState;
                TileEntityTransmitter transmitterTile;
                BlockState state;
                IUpgradeableTransmitter upgradeableTransmitter;
                if (!(transmitter instanceof IUpgradeableTransmitter) || !(upgradeableTransmitter = (IUpgradeableTransmitter)((Object)transmitter)).canUpgrade(tier) || (state = (transmitterTile = transmitter.getTransmitterTile()).m_58900_()) == (upgradeState = transmitterTile.upgradeResult(state, tier.getBaseTier()))) continue;
                if (!sharesSet) {
                    if (transmitterNetwork instanceof DynamicBufferedNetwork) {
                        DynamicBufferedNetwork dynamicNetwork = (DynamicBufferedNetwork)transmitterNetwork;
                        dynamicNetwork.validateSaveShares((BufferedTransmitter)transmitter);
                    }
                    sharesSet = true;
                }
                transmitter.startUpgrading();
                Object upgradeData = upgradeableTransmitter.getUpgradeData();
                BlockPos transmitterPos = transmitter.getTilePos();
                Level transmitterWorld = transmitter.getTileWorld();
                if (upgradeData == null) {
                    Mekanism.logger.warn("Got no upgrade data for transmitter at position: {} in {} but it said it would be able to provide some.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                transmitterWorld.m_46597_(transmitterPos, upgradeState);
                TileEntityTransmitter upgradedTile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)transmitterWorld, transmitterPos);
                if (upgradedTile == null) {
                    Mekanism.logger.warn("Error upgrading transmitter at position: {} in {}.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                Transmitter<?, ?, ?> upgradedTransmitter = upgradedTile.getTransmitter();
                if (upgradedTransmitter instanceof IUpgradeableTransmitter) {
                    this.transferUpgradeData((IUpgradeableTransmitter)((Object)upgradedTransmitter), (TransmitterUpgradeData)upgradeData);
                } else {
                    Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
                }
                if (++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0) {
                ((DynamicNetwork)transmitterNetwork).invalidate(null);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
        }
    }

    private <DATA extends TransmitterUpgradeData> void transferUpgradeData(IUpgradeableTransmitter<DATA> upgradeableTransmitter, TransmitterUpgradeData data) {
        if (upgradeableTransmitter.dataTypeMatches(data)) {
            upgradeableTransmitter.parseUpgradeData(data);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
        }
    }

    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        return current;
    }

    public void sideChanged(@Nonnull Direction side, @Nonnull ConnectionType old, @Nonnull ConnectionType type) {
    }

    protected DynamicHandler.InteractPredicate getExtractPredicate() {
        return (tank, side) -> {
            if (side == null) {
                return true;
            }
            ConnectionType connectionType = this.getTransmitter().getConnectionType(side);
            return connectionType == ConnectionType.NORMAL || connectionType == ConnectionType.PUSH;
        };
    }

    protected DynamicHandler.InteractPredicate getInsertPredicate() {
        return (tank, side) -> {
            if (side == null) {
                return true;
            }
            ConnectionType connectionType = this.getTransmitter().getConnectionType(side);
            return connectionType == ConnectionType.NORMAL || connectionType == ConnectionType.PULL;
        };
    }
}

