/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.text;

import mekanism.api.Upgrade;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import net.minecraft.network.chat.Component;

public class UpgradeDisplay
implements IHasTextComponent {
    private final Upgrade upgrade;
    private final int level;

    private UpgradeDisplay(Upgrade upgrade, int level) {
        this.upgrade = upgrade;
        this.level = level;
    }

    public static UpgradeDisplay of(Upgrade upgrade) {
        return UpgradeDisplay.of(upgrade, 0);
    }

    public static UpgradeDisplay of(Upgrade upgrade, int level) {
        return new UpgradeDisplay(upgrade, level);
    }

    @Override
    public Component getTextComponent() {
        if (this.upgrade.getMax() > 1 && this.level > 0) {
            return MekanismLang.UPGRADE_DISPLAY_LEVEL.translateColored(this.upgrade.getColor(), this.upgrade, EnumColor.GRAY, this.level);
        }
        return MekanismLang.UPGRADE_DISPLAY.translateColored(this.upgrade.getColor(), this.upgrade);
    }
}

