/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.TextField;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.SharedConstants;

public class TextFieldVanilla
extends TextField {
    private static final int BACKGROUND_WIDTH_OFFSET = 8;
    private static final float BACKGROUND_X_TRANSLATE = 4.0f;
    private static final int BACKGROUND_Y_TRANSLATE_OFFSET = 8;
    private static final int BACKGROUND_MOUSE_OFFSET_X = 4;
    private boolean backgroundEnabled = true;
    private int backgroundOuterColor = -6250336;
    private int backgroundInnerColor = -16777216;

    public TextFieldVanilla() {
        this.filter = new FilterVanilla();
    }

    public TextFieldVanilla(PaneParams params) {
        super(params);
        this.backgroundEnabled = params.getBoolean("background", this.backgroundEnabled);
        this.backgroundOuterColor = params.getColor("backgroundOuter", this.backgroundOuterColor);
        this.backgroundInnerColor = params.getColor("backgroundInner", this.backgroundInnerColor);
        this.filter = new FilterVanilla();
    }

    public boolean isBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    public void setBackgroundEnabled(boolean e) {
        this.backgroundEnabled = e;
    }

    public int getBackgroundOuterColor() {
        return this.backgroundOuterColor;
    }

    public void setBackgroundOuterColor(int c) {
        this.backgroundOuterColor = c;
    }

    public int getBackgroundInnerColor() {
        return this.backgroundInnerColor;
    }

    public void setBackgroundInnerColor(int c) {
        this.backgroundInnerColor = c;
    }

    @Override
    public int getInternalWidth() {
        return this.backgroundEnabled ? this.getWidth() - 8 : this.getWidth();
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
        if (this.backgroundEnabled) {
            TextFieldVanilla.drawLineRect(ms, this.x - 1, this.y - 1, this.width + 2, this.height + 2, this.backgroundOuterColor);
            TextFieldVanilla.fill(ms, this.x, this.y, this.width, this.height, this.backgroundInnerColor);
            ms.m_85836_();
            ms.m_85837_(4.0, (double)((this.height - 8) / 2), 0.0);
        }
        super.drawSelf(ms, mx, my);
        if (this.backgroundEnabled) {
            ms.m_85849_();
        }
    }

    @Override
    public boolean handleClick(double mx, double my) {
        double mouseX = mx;
        if (this.backgroundEnabled) {
            mouseX -= 4.0;
        }
        super.handleClick(mouseX, my);
        return true;
    }

    private static class FilterVanilla
    implements TextField.Filter {
        private FilterVanilla() {
        }

        @Override
        public String filter(String s) {
            return SharedConstants.m_136190_((String)s);
        }

        @Override
        public boolean isAllowedCharacter(char c) {
            return SharedConstants.m_136188_((char)c);
        }
    }
}

