/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix.mixin;

import net.blay09.mods.netherportalfix.NetherPortalFix;
import net.blay09.mods.netherportalfix.ReturnPortalManager;
import net.blay09.mods.netherportalfix.mixin.LivingEntityAccessor;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class ForgeServerPlayerMixin {
    private static final ThreadLocal<ResourceKey<Level>> fromDimHolder = new ThreadLocal();

    @Inject(remap=false, method={"changeDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraftforge/common/util/ITeleporter;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="HEAD")})
    public void changeDimensionHead(ServerLevel level, ITeleporter teleporter, CallbackInfoReturnable<Entity> callbackInfo) {
        ServerPlayer player = (ServerPlayer)this;
        fromDimHolder.set((ResourceKey<Level>)player.f_19853_.m_46472_());
    }

    @Inject(remap=false, method={"changeDimension(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraftforge/common/util/ITeleporter;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")})
    public void changeDimensionTail(ServerLevel level, ITeleporter teleporter, CallbackInfoReturnable<Entity> callbackInfo) {
        ServerPlayer player = (ServerPlayer)this;
        ResourceKey<Level> fromDim = fromDimHolder.get();
        ResourceKey toDim = level.m_46472_();
        ResourceKey OVERWORLD = Level.f_46428_;
        ResourceKey THE_NETHER = Level.f_46429_;
        if (fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD) {
            BlockUtil.FoundRectangle fromPortal = ReturnPortalManager.findPortalAt((Player)player, fromDim, ((LivingEntityAccessor)player).getLastPos());
            BlockPos toPos = player.m_142538_();
            if (fromPortal != null) {
                ReturnPortalManager.storeReturnPortal(player, (ResourceKey<Level>)toDim, toPos, fromPortal);
                NetherPortalFix.logger.info("Storing return portal from {} to {} in {}", (Object)toDim, (Object)fromPortal.f_124348_, fromDim);
            } else {
                NetherPortalFix.logger.info("Not storing return portal because I'm not in a portal.");
            }
        } else {
            NetherPortalFix.logger.info("Not storing return portal because it's from {} to {}", fromDim, (Object)toDim);
        }
    }
}

