/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements.building_add_recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.IRecipeStorage;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class BuildingAddRecipeCriterionInstance
extends AbstractCriterionTriggerInstance {
    private ItemPredicate[] outputItemPredicates;
    private int craftingSize = -1;

    public BuildingAddRecipeCriterionInstance() {
        super(new ResourceLocation("minecolonies", "building_add_recipe"), EntityPredicate.Composite.f_36667_);
    }

    public BuildingAddRecipeCriterionInstance(ItemPredicate[] outputItemPredicates) {
        super(new ResourceLocation("minecolonies", "building_add_recipe"), EntityPredicate.Composite.f_36667_);
        this.outputItemPredicates = outputItemPredicates;
    }

    public BuildingAddRecipeCriterionInstance(ItemPredicate[] outputItemPredicates, int craftingSize) {
        super(new ResourceLocation("minecolonies", "building_add_recipe"), EntityPredicate.Composite.f_36667_);
        this.outputItemPredicates = outputItemPredicates;
        this.craftingSize = craftingSize;
    }

    public boolean test(IRecipeStorage recipeStorage) {
        if (this.outputItemPredicates != null) {
            boolean outputMatches = false;
            for (ItemPredicate itemPredicate : this.outputItemPredicates) {
                if (!itemPredicate.m_45049_(recipeStorage.getPrimaryOutput())) continue;
                outputMatches = true;
                break;
            }
            if (this.craftingSize != -1) {
                return outputMatches && this.craftingSize == recipeStorage.getGridSize();
            }
            return outputMatches;
        }
        return true;
    }

    @NotNull
    public static BuildingAddRecipeCriterionInstance deserializeFromJson(@NotNull JsonObject jsonObject, @NotNull DeserializationContext context) {
        if (jsonObject.has("items")) {
            ItemPredicate[] outputItemPredicates = ItemPredicate.m_45055_((JsonElement)jsonObject.get("items"));
            if (jsonObject.has("crafting_size")) {
                int craftingSize = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"crafting_size");
                return new BuildingAddRecipeCriterionInstance(outputItemPredicates, craftingSize);
            }
            return new BuildingAddRecipeCriterionInstance(outputItemPredicates);
        }
        return new BuildingAddRecipeCriterionInstance();
    }

    @NotNull
    public JsonObject m_7683_(@NotNull SerializationContext context) {
        JsonObject json = super.m_7683_(context);
        if (this.outputItemPredicates != null && this.outputItemPredicates.length > 0) {
            JsonArray outputItemPredicates = new JsonArray();
            for (ItemPredicate predicate : this.outputItemPredicates) {
                outputItemPredicates.add(predicate.m_45048_());
            }
            json.add("items", (JsonElement)outputItemPredicates);
        }
        if (this.craftingSize >= 0) {
            json.addProperty("crafting_size", (Number)this.craftingSize);
        }
        return json;
    }
}

