/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.interactionhandling.registry;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public final class InteractionResponseHandlerEntry
extends ForgeRegistryEntry<InteractionResponseHandlerEntry> {
    private final Function<ICitizen, IInteractionResponseHandler> responseHandlerProducer;

    public Function<ICitizen, IInteractionResponseHandler> getProducer() {
        return this.responseHandlerProducer;
    }

    private InteractionResponseHandlerEntry(Function<ICitizen, IInteractionResponseHandler> producer) {
        this.responseHandlerProducer = producer;
    }

    public static final class Builder {
        private Function<ICitizen, IInteractionResponseHandler> responseHandlerProducer;
        private ResourceLocation registryName;

        public Builder setResponseHandlerProducer(Function<ICitizen, IInteractionResponseHandler> responseHandlerProducer) {
            this.responseHandlerProducer = responseHandlerProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public InteractionResponseHandlerEntry createEntry() {
            Validate.notNull(this.responseHandlerProducer);
            Validate.notNull((Object)this.registryName);
            return (InteractionResponseHandlerEntry)new InteractionResponseHandlerEntry(this.responseHandlerProducer).setRegistryName(this.registryName);
        }
    }
}

