/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.request;

import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import org.jetbrains.annotations.NotNull;

public interface IRequestFactory<T extends IRequestable, R extends IRequest<T>>
extends IFactory<T, R> {
    public static final int NUMBER_OF_PROPERTIES = 2;

    @Override
    @NotNull
    default public R getNewInstance(@NotNull IFactoryController factoryController, @NotNull T t, Object ... context) throws IllegalArgumentException {
        if (context.length != 2 && context.length != 3) {
            throw new IllegalArgumentException("Unsupported context - Too many parameters.");
        }
        if (!(context[0] instanceof IToken)) {
            throw new IllegalArgumentException("Unsupported context - First context object is not a token");
        }
        if (!(context[1] instanceof IRequester)) {
            throw new IllegalArgumentException("Unsupported context - Second context object should be a location");
        }
        if (context.length == 2) {
            IRequester requester = (IRequester)context[1];
            IToken token = (IToken)context[0];
            return this.getNewInstance(t, requester, token);
        }
        if (!(context[2] instanceof RequestState)) {
            throw new IllegalArgumentException("Unsupported context - Third context object is not a request state");
        }
        IRequester requester = (IRequester)context[1];
        IToken token = (IToken)context[0];
        RequestState state = (RequestState)((Object)context[2]);
        return this.getNewInstance(t, requester, token, state);
    }

    default public R getNewInstance(@NotNull T input, @NotNull IRequester location, @NotNull IToken<?> token) {
        return this.getNewInstance(input, location, token, RequestState.CREATED);
    }

    public R getNewInstance(@NotNull T var1, @NotNull IRequester var2, @NotNull IToken<?> var3, @NotNull RequestState var4);
}

