/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericRecipe
implements IGenericRecipe {
    @Nullable
    private final ResourceLocation id;
    private final ItemStack output;
    private final List<ItemStack> allMultiOutputs;
    private final List<ItemStack> additionalOutputs;
    private final List<List<ItemStack>> inputs;
    private final int gridSize;
    private final Block intermediate;
    private final ResourceLocation lootTable;
    private final List<Component> restrictions;
    private final int levelSort;

    @Nullable
    public static IGenericRecipe of(@Nullable Recipe<?> recipe, @Nullable Level world) {
        Block intermediate;
        int size;
        if (recipe == null) {
            return null;
        }
        List<List<ItemStack>> inputs = recipe.m_7527_().stream().map(ingredient -> Arrays.asList(ingredient.m_43908_())).collect(Collectors.toList());
        if (recipe instanceof SmeltingRecipe) {
            size = 1;
            intermediate = Blocks.f_50094_;
        } else {
            size = recipe.m_8004_(2, 2) ? 2 : 3;
            intermediate = Blocks.f_50016_;
        }
        return new GenericRecipe(recipe.m_6423_(), recipe.m_8043_(), GenericRecipe.calculateSecondaryOutputs(recipe, world), inputs, size, intermediate, null, new ArrayList<Component>(), -1);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IRecipeStorage storage, @NotNull List<Component> restrictions, int levelSort) {
        if (storage == null) {
            return null;
        }
        List<List<ItemStack>> inputs = storage.getCleanedInput().stream().map(input -> Collections.singletonList(GenericRecipe.toItemStack(input))).collect(Collectors.toList());
        return new GenericRecipe(storage.getRecipeSource(), storage.getPrimaryOutput(), storage.getAlternateOutputs(), storage.getSecondaryOutputs(), inputs, storage.getGridSize(), storage.getIntermediate(), storage.getLootTable(), restrictions, levelSort);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IRecipeStorage storage) {
        return GenericRecipe.of(storage, new ArrayList<Component>(), -1);
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IToken<?> recipeToken) {
        if (recipeToken == null) {
            return null;
        }
        return GenericRecipe.of((IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(recipeToken));
    }

    public GenericRecipe(@Nullable ResourceLocation id, @NotNull ItemStack output, @NotNull List<ItemStack> additionalOutputs, @NotNull List<List<ItemStack>> inputs, int gridSize, @NotNull Block intermediate, @Nullable ResourceLocation lootTable, @NotNull List<Component> restrictions, int levelSort) {
        this.id = id == null || id.m_135815_().isEmpty() ? null : id;
        this.output = output;
        this.allMultiOutputs = Collections.singletonList(output);
        this.additionalOutputs = Collections.unmodifiableList(additionalOutputs);
        this.inputs = Collections.unmodifiableList(inputs);
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.lootTable = lootTable;
        this.restrictions = Collections.unmodifiableList(restrictions);
        this.levelSort = levelSort;
    }

    public GenericRecipe(@Nullable ResourceLocation id, @NotNull ItemStack output, @NotNull List<ItemStack> altOutputs, @NotNull List<ItemStack> additionalOutputs, @NotNull List<List<ItemStack>> inputs, int gridSize, @NotNull Block intermediate, @Nullable ResourceLocation lootTable, @NotNull List<Component> restrictions, int levelSort) {
        this.id = id;
        this.output = output;
        this.allMultiOutputs = Collections.unmodifiableList(Stream.concat(Stream.of(output), altOutputs.stream()).collect(Collectors.toList()));
        this.additionalOutputs = Collections.unmodifiableList(additionalOutputs);
        this.inputs = Collections.unmodifiableList(inputs);
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.lootTable = lootTable;
        this.restrictions = Collections.unmodifiableList(restrictions);
        this.levelSort = levelSort;
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    @Override
    @Nullable
    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return this.allMultiOutputs;
    }

    @Override
    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return this.additionalOutputs;
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Override
    @NotNull
    public List<Component> getRestrictions() {
        return this.restrictions;
    }

    @Override
    public int getLevelSort() {
        return this.levelSort;
    }

    @Override
    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return predicate.test(this.output);
    }

    @Override
    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        for (List<ItemStack> slot : this.inputs) {
            for (ItemStack stack : slot) {
                Optional<Boolean> result = predicate.test(stack);
                if (!result.isPresent()) continue;
                return result;
            }
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Block getIntermediate() {
        return this.intermediate;
    }

    @Override
    @Nullable
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public String toString() {
        return "GenericRecipe{output=" + this.output + "}";
    }

    @NotNull
    private static ItemStack toItemStack(@NotNull ItemStorage input) {
        ItemStack result = input.getItemStack().m_41777_();
        result.m_41764_(input.getAmount());
        return result;
    }

    @NotNull
    private static List<ItemStack> calculateSecondaryOutputs(@NotNull Recipe<?> recipe, @Nullable Level world) {
        if (recipe instanceof CraftingRecipe) {
            NonNullList inputs = recipe.m_7527_();
            CraftingContainer inv = new CraftingContainer(new AbstractContainerMenu(MenuType.f_39968_, 0){

                public boolean m_6875_(@NotNull Player playerIn) {
                    return false;
                }
            }, 3, 3);
            for (int slot = 0; slot < inputs.size(); ++slot) {
                ItemStack[] stacks = ((Ingredient)inputs.get(slot)).m_43908_();
                if (stacks.length <= 0) continue;
                inv.m_6836_(slot, stacks[0]);
            }
            if (((CraftingRecipe)recipe).m_5818_((Container)inv, world)) {
                return ((CraftingRecipe)recipe).m_7457_((Container)inv).stream().filter(ItemStackUtils::isNotEmpty).filter(stack -> stack.m_41720_() != ModItems.buildTool.get()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }
}

