/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.pathfinding;

import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SurfaceType {
    WALKABLE,
    DROPABLE,
    NOT_PASSABLE;


    @NotNull
    public static SurfaceType getSurfaceType(BlockGetter world, BlockState blockState, BlockPos pos) {
        Block block = blockState.m_60734_();
        if (block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof AbstractBlockMinecoloniesDefault || block instanceof AbstractBlockBarrel || block instanceof BambooBlock || block instanceof DoorBlock || block instanceof MagmaBlock || block instanceof PowderSnowBlock) {
            return NOT_PASSABLE;
        }
        VoxelShape shape = blockState.m_60808_(world, pos);
        if (shape.m_83297_(Direction.Axis.Y) > 1.0) {
            return NOT_PASSABLE;
        }
        FluidState fluid = world.m_6425_(pos);
        if (blockState.m_60734_() == Blocks.f_49991_ || fluid != null && !fluid.m_76178_() && (fluid.m_76152_() == Fluids.f_76195_ || fluid.m_76152_() == Fluids.f_76194_)) {
            return NOT_PASSABLE;
        }
        if (SurfaceType.isWater(world, pos, blockState, fluid)) {
            return WALKABLE;
        }
        if (block instanceof AbstractBlockMinecoloniesConstructionTape || block instanceof SignBlock || block instanceof VineBlock) {
            return DROPABLE;
        }
        if (blockState.m_60767_().m_76333_() && shape.m_83297_(Direction.Axis.X) - shape.m_83288_(Direction.Axis.X) > 0.75 && shape.m_83297_(Direction.Axis.Z) - shape.m_83288_(Direction.Axis.Z) > 0.75 || blockState.m_60734_() == Blocks.f_50125_ && (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) > 1 || block instanceof FloatingCarpetBlock || block instanceof CarpetBlock) {
            return WALKABLE;
        }
        return DROPABLE;
    }

    public static boolean isWater(@NotNull BlockGetter world, BlockPos pos) {
        return SurfaceType.isWater(world, pos, null, null);
    }

    public static boolean isWater(@NotNull BlockGetter world, BlockPos pos, @Nullable BlockState pState, @Nullable FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.m_8055_(pos);
        }
        if (state.m_60815_()) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_49990_) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = world.m_6425_(pos);
        }
        if (fluidState == null || fluidState.m_76178_()) {
            return false;
        }
        Fluid fluid = fluidState.m_76152_();
        return fluid == Fluids.f_76193_ || fluid == Fluids.f_76192_;
    }
}

