/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.minecolonies.api.loot.ModLootConditions;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityInBiomeCategory
implements LootItemCondition {
    @Nullable
    private final Biome.BiomeCategory category;

    private EntityInBiomeCategory(@Nullable Biome.BiomeCategory category) {
        this.category = category;
    }

    public static LootItemCondition.Builder any() {
        return () -> new EntityInBiomeCategory(null);
    }

    public static LootItemCondition.Builder of(@NotNull Biome.BiomeCategory category) {
        return () -> new EntityInBiomeCategory(category);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return ModLootConditions.entityInBiomeCategory;
    }

    public boolean test(@NotNull LootContext lootContext) {
        if (this.category == null) {
            return true;
        }
        Entity entity = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        if (entity != null && entity.f_19853_ != null) {
            Biome biome = (Biome)entity.f_19853_.m_204166_(entity.m_142538_()).m_203334_();
            return biome.m_47567_().equals((Object)this.category);
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<EntityInBiomeCategory> {
        public void serialize(@NotNull JsonObject json, @NotNull EntityInBiomeCategory condition, @NotNull JsonSerializationContext context) {
            if (condition.category != null) {
                json.addProperty("category", condition.category.m_7912_());
            }
        }

        @NotNull
        public EntityInBiomeCategory deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            String categoryId = GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)"");
            Biome.BiomeCategory category = Biome.BiomeCategory.m_47643_((String)categoryId);
            return new EntityInBiomeCategory(category);
        }
    }
}

