/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.inventory.container.ContainerBuildingInventory;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityColonyBuilding
extends AbstractTileEntityColonyBuilding
implements ITickable {
    private static final String TAG_COLONY = "colony";
    private static final String TAG_MIRROR = "mirror";
    private static final String TAG_STYLE = "style";
    private int colonyId = 0;
    private IColony colony;
    private IBuilding building;
    private boolean mirror;
    private String style = "";
    public ResourceLocation registryName;
    private LazyOptional<CombinedItemHandler> combinedInv;

    public TileEntityColonyBuilding(BlockPos pos, BlockState state) {
        this(MinecoloniesTileEntities.BUILDING, pos, state);
    }

    public TileEntityColonyBuilding(BlockEntityType<? extends AbstractTileEntityColonyBuilding> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public IColony getColony() {
        if (this.colony == null) {
            this.updateColonyReferences();
        }
        return this.colony;
    }

    private void updateColonyReferences() {
        if (this.colony == null && this.m_58904_() != null) {
            this.colony = this.colonyId == 0 ? IColonyManager.getInstance().getColonyByPosFromWorld(this.m_58904_(), this.m_58899_()) : IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.m_58904_());
            if (this.colony != null || !this.m_58904_().f_46443_) {
                // empty if block
            }
        }
        if (this.building == null && this.colony != null) {
            this.building = this.colony.getBuildingManager().getBuilding(this.getPosition());
            if (!(this.building == null || this.m_58904_() != null && this.m_58904_().f_46443_)) {
                this.building.setTileEntity(this);
            }
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.f_58858_;
    }

    @Override
    @Nullable
    public BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        Predicate<ItemStack> notEmptyPredicate = itemStackSelectionPredicate.and(ItemStackUtils.NOT_EMPTY_PREDICATE);
        @Nullable IBuilding theBuilding = this.getBuilding();
        if (theBuilding != null) {
            for (BlockPos pos : theBuilding.getContainers()) {
                BlockEntity entity;
                if (!WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, pos) || !((entity = this.m_58904_().m_7702_(pos)) instanceof AbstractTileEntityRack ? ((AbstractTileEntityRack)entity).hasItemStack(notEmptyPredicate) : TileEntityColonyBuilding.isInTileEntity((ICapabilityProvider)entity, notEmptyPredicate))) continue;
                return pos;
            }
        }
        return null;
    }

    @Override
    public void setColony(IColony c) {
        this.colony = c;
        this.colonyId = c.getID();
        this.m_6596_();
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (this.building != null) {
            this.building.markDirty();
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.colonyId = compound.m_128451_(TAG_COLONY);
        super.onDataPacket(net, packet);
    }

    public void onLoad() {
        if (this.building != null) {
            this.building.setTileEntity(null);
        }
    }

    @Override
    public IBuilding getBuilding() {
        if (this.building == null) {
            this.updateColonyReferences();
        }
        return this.building;
    }

    @Override
    public void setBuilding(IBuilding b) {
        this.building = b;
    }

    @Override
    @NotNull
    public Component m_5446_() {
        if (this.m_58900_() == null) {
            return super.m_5446_();
        }
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_() + ".name");
    }

    @Override
    public IBuildingView getBuildingView() {
        IColonyView c = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)this.f_58857_.m_46472_());
        return c == null ? null : c.getBuilding(this.getPosition());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128431_().contains(TAG_COLONY)) {
            this.colonyId = compound.m_128451_(TAG_COLONY);
        }
        this.mirror = compound.m_128471_(TAG_MIRROR);
        this.style = compound.m_128461_(TAG_STYLE);
        this.registryName = new ResourceLocation(compound.m_128461_("type"));
        this.buildingPos = this.f_58858_;
        this.single = true;
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_(TAG_COLONY, this.colonyId);
        compound.m_128379_(TAG_MIRROR, this.mirror);
        compound.m_128359_(TAG_STYLE, this.style);
        compound.m_128359_("type", this.registryName.toString());
    }

    @Override
    public void tick() {
        IColony tempColony;
        if (this.combinedInv != null) {
            this.combinedInv.invalidate();
            this.combinedInv = null;
        }
        if (!this.m_58904_().f_46443_ && this.colonyId == 0 && (tempColony = IColonyManager.getInstance().getColonyByPosFromWorld(this.m_58904_(), this.getPosition())) != null) {
            this.colonyId = tempColony.getID();
        }
        if (!this.m_58904_().f_46443_ && this.colonyId != 0 && this.colony == null) {
            this.updateColonyReferences();
        }
    }

    public boolean isUsableByPlayer(@NotNull Player player) {
        return this.hasAccessPermission(player);
    }

    @Override
    public boolean hasAccessPermission(Player player) {
        return this.building == null || this.building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS);
    }

    @Override
    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    @Override
    public boolean isMirrored() {
        return this.mirror;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public ResourceLocation getBuildingName() {
        return this.registryName;
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public void updateBlockState() {
    }

    @Override
    public void setSingle(boolean single) {
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (!this.f_58859_ && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getBuilding() != null) {
            if (this.combinedInv == null) {
                LinkedHashSet<IItemHandlerModifiable> handlers = new LinkedHashSet<IItemHandlerModifiable>();
                Level world = this.colony.getWorld();
                if (world != null) {
                    for (BlockPos pos : this.building.getContainers()) {
                        BlockEntity te;
                        if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos) || pos.equals((Object)this.f_58858_) || (te = world.m_7702_(pos)) == null) continue;
                        if (te instanceof AbstractTileEntityRack) {
                            LazyOptional cap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                            cap.ifPresent(theCap -> {
                                if (theCap instanceof IItemHandlerModifiable && theCap.getSlots() >= 5) {
                                    handlers.add((IItemHandlerModifiable)theCap);
                                }
                            });
                            ((AbstractTileEntityRack)te).setBuildingPos(this.m_58899_());
                            continue;
                        }
                        this.building.removeContainerPosition(pos);
                    }
                }
                handlers.add(this.getInventory());
                this.combinedInv = LazyOptional.of(() -> new CombinedItemHandler(this.building.getSchematicName(), handlers.toArray(new IItemHandlerModifiable[0])));
            }
            return this.combinedInv;
        }
        return super.getCapability(capability, side);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ContainerBuildingInventory(id, inv, this.colonyId, this.m_58899_());
    }

    public void reactivate() {
        ArrayList tags = new ArrayList(this.getPositionedTags().get(BlockPos.f_121853_));
        tags.remove("deactivated");
        if (!tags.isEmpty()) {
            this.setStyle((String)tags.get(0));
        }
        String structureName = new StructureName("schematics", this.getStyle(), this.getSchematicName()).toString();
        LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(this.f_58857_, this.getPosition(), structureName, new PlacementSettings(), true);
        Blueprint blueprint = structure.getBluePrint();
        BlockState structureState = ((BlockInfo)structure.getBluePrint().getBlockInfoAsMap().get(structure.getBluePrint().getPrimaryBlockOffset())).getState();
        if (structureState != null) {
            int worldRotation;
            if (!(structureState.m_60734_() instanceof AbstractBlockHut) || !(this.f_58857_.m_8055_(this.getPosition()).m_60734_() instanceof AbstractBlockHut)) {
                Log.getLogger().error(String.format("Schematic %s doesn't have a correct Primary Offset", structureName.toString()));
                return;
            }
            int structureRotation = ((Direction)structureState.m_61143_((Property)AbstractBlockHut.FACING)).m_122416_();
            int rotation = structureRotation <= (worldRotation = ((Direction)this.f_58857_.m_8055_(this.getPosition()).m_61143_((Property)AbstractBlockHut.FACING)).m_122416_()) ? worldRotation - structureRotation : 4 + worldRotation - structureRotation;
            blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotation), this.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, this.f_58857_);
            BlockInfo info = blueprint.getBlockInfoAsMap().getOrDefault(blueprint.getPrimaryBlockOffset(), null);
            if (info.getTileEntityData() != null) {
                this.readSchematicDataFromNBT(info.getTileEntityData());
            }
        }
    }
}

