/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockPosUtil {
    private static final int MAX_DEPTH = 50;
    private static final int BLOCKPOS_LENGTH = 3;
    public static final BiPredicate<BlockGetter, BlockPos> SOLID_AIR_POS_SELECTOR = (world, pos) -> (world.m_8055_(pos).m_60815_() || world.m_8055_(pos).m_60767_().m_76332_()) && world.m_8055_(pos.m_7494_()).m_60767_() == Material.f_76296_ && world.m_8055_(pos.m_6630_(2)).m_60767_() == Material.f_76296_;
    public static final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR_POS_SELECTOR = (world, pos) -> world.m_8055_(pos).m_60767_() == Material.f_76296_ && world.m_8055_(pos.m_6630_(1)).m_60767_() == Material.f_76296_;

    private BlockPosUtil() {
    }

    public static CompoundTag write(@NotNull CompoundTag compound, String name, @NotNull BlockPos pos) {
        @NotNull CompoundTag coordsCompound = new CompoundTag();
        coordsCompound.m_128405_("x", pos.m_123341_());
        coordsCompound.m_128405_("y", pos.m_123342_());
        coordsCompound.m_128405_("z", pos.m_123343_());
        compound.m_128365_(name, (Tag)coordsCompound);
        return compound;
    }

    @NotNull
    public static CompoundTag writeOptional(@NotNull CompoundTag compound, @NotNull String name, @Nullable BlockPos value) {
        if (value != null) {
            BlockPosUtil.write(compound, name, value);
        }
        return compound;
    }

    public static Tuple<Direction, Direction> getRandomDirectionTuple(Random random) {
        return new Tuple((Object)Direction.m_122404_((Random)random), (Object)Direction.m_122404_((Random)random));
    }

    public static BlockPos getRandomPosition(Level world, BlockPos currentPosition, BlockPos def, int minDist, int maxDist) {
        Random random = world.f_46441_;
        int tries = 0;
        BlockPos pos = null;
        while (!(pos != null && WorldUtil.isEntityBlockLoaded((LevelAccessor)world, pos) && !world.m_8055_(pos).m_60767_().m_76332_() && world.m_8055_(pos.m_7495_()).m_60767_().m_76333_() && world.m_46859_(pos) && world.m_46859_(pos.m_7494_()))) {
            Tuple<Direction, Direction> direction = BlockPosUtil.getRandomDirectionTuple(random);
            pos = new BlockPos((Vec3i)currentPosition).m_5484_((Direction)direction.m_14418_(), random.nextInt(maxDist) + minDist).m_5484_((Direction)direction.m_14419_(), random.nextInt(maxDist) + minDist).m_6630_(random.nextInt(3)).m_6625_(random.nextInt(3));
            if (tries >= 20) {
                return def;
            }
            ++tries;
        }
        return pos;
    }

    @NotNull
    public static BlockPos read(@NotNull CompoundTag compound, String name) {
        CompoundTag coordsCompound = compound.m_128469_(name);
        int x = coordsCompound.m_128451_("x");
        int y = coordsCompound.m_128451_("y");
        int z = coordsCompound.m_128451_("z");
        return new BlockPos(x, y, z);
    }

    @Nullable
    public static BlockPos readOrNull(@NotNull CompoundTag compound, @NotNull String name) {
        BlockPos result = BlockPosUtil.read(compound, name);
        return result.equals((Object)BlockPos.f_121853_) ? null : result;
    }

    public static void writeToListNBT(@NotNull ListTag tagList, @NotNull BlockPos pos) {
        @NotNull CompoundTag coordsCompound = new CompoundTag();
        coordsCompound.m_128405_("x", pos.m_123341_());
        coordsCompound.m_128405_("y", pos.m_123342_());
        coordsCompound.m_128405_("z", pos.m_123343_());
        tagList.add((Object)coordsCompound);
    }

    public static void writePosListToNBT(CompoundTag compoundNBT, String tagname, List<BlockPos> positions) {
        ListTag listNBT = new ListTag();
        for (BlockPos pos : positions) {
            BlockPosUtil.writeToListNBT(listNBT, pos);
        }
        compoundNBT.m_128365_(tagname, (Tag)listNBT);
    }

    public static List<BlockPos> readPosListFromNBT(CompoundTag compoundNBT, String tagname) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        ListTag listNBT = compoundNBT.m_128437_(tagname, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            result.add(BlockPosUtil.readFromListNBT(listNBT, i));
        }
        return result;
    }

    @NotNull
    public static BlockPos readFromListNBT(@NotNull ListTag tagList, int index) {
        CompoundTag coordsCompound = tagList.m_128728_(index);
        int x = coordsCompound.m_128451_("x");
        int y = coordsCompound.m_128451_("y");
        int z = coordsCompound.m_128451_("z");
        return new BlockPos(x, y, z);
    }

    @Nullable
    public static BlockPos getBlockPosOfString(@NotNull String inputText) {
        String[] strings = inputText.split(" ");
        if (strings.length == 3) {
            try {
                int x = Integer.parseInt(strings[0]);
                int y = Integer.parseInt(strings[1]);
                int z = Integer.parseInt(strings[2]);
                return new BlockPos(x, y, z);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public static String getString(@NotNull BlockPos position) {
        return "{x=" + position.m_123341_() + ", y=" + position.m_123342_() + ", z=" + position.m_123343_() + "}";
    }

    public static boolean isPositionSafe(@NotNull Level sender, BlockPos blockPos) {
        return !(sender.m_8055_(blockPos).m_60734_() instanceof AirBlock) && !sender.m_8055_(blockPos).m_60767_().m_76332_() && !sender.m_8055_(blockPos.m_7495_()).m_60767_().m_76332_() && sender.m_6857_().m_61937_(blockPos);
    }

    public static BlockPos findLand(BlockPos blockPos, Level world) {
        int top = blockPos.m_123342_();
        int bot = 0;
        int mid = blockPos.m_123342_();
        BlockPos foundland = null;
        BlockPos tempPos = blockPos;
        while (top >= bot) {
            Block block = world.m_8055_(tempPos = new BlockPos(tempPos.m_123341_(), mid, tempPos.m_123343_())).m_60734_();
            if (block instanceof AirBlock && world.m_46861_(tempPos)) {
                top = mid - 1;
                foundland = tempPos;
            } else {
                bot = mid + 1;
                foundland = tempPos;
            }
            mid = (bot + top) / 2;
        }
        if (world.m_8055_(tempPos).m_60767_().m_76333_()) {
            return foundland.m_7494_();
        }
        return foundland;
    }

    public static double getValidHeight(@NotNull Vec3 position, @NotNull Level world) {
        double returnHeight = position.f_82480_;
        if (position.f_82480_ < (double)world.m_141937_()) {
            returnHeight = world.m_141937_();
        }
        while (returnHeight >= 1.0 && world.m_46859_(new BlockPos(Mth.m_14107_((double)position.f_82479_), (int)returnHeight, Mth.m_14107_((double)position.f_82481_)))) {
            returnHeight -= 1.0;
        }
        while (!world.m_46859_(new BlockPos(Mth.m_14107_((double)position.f_82479_), (int)returnHeight, Mth.m_14107_((double)position.f_82481_)))) {
            returnHeight += 1.0;
        }
        return returnHeight;
    }

    public static long getDistanceSquared(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.m_123341_() - (long)block2.m_123341_();
        long result = xDiff * xDiff + (yDiff = (long)block1.m_123342_() - (long)block2.m_123342_()) * yDiff + (zDiff = (long)block1.m_123343_() - (long)block2.m_123343_()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static long getDistance2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long xDiff = Math.abs((long)block1.m_123341_() - (long)block2.m_123341_());
        long zDiff = Math.abs((long)block1.m_123343_() - (long)block2.m_123343_());
        return Math.abs(xDiff + zDiff);
    }

    public static int getMaxDistance2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        int xDif = Math.abs(block1.m_123341_() - block2.m_123341_());
        int zDif = Math.abs(block1.m_123343_() - block2.m_123343_());
        return Math.max(xDif, zDif);
    }

    public static double getDistance(BlockPos pos1, BlockPos pos2) {
        long xDiff = pos1.m_123341_() - pos2.m_123341_();
        long yDiff = pos1.m_123342_() - pos2.m_123342_();
        long zDiff = pos1.m_123343_() - pos2.m_123343_();
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    public static long getDistanceSquared2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long xDiff = (long)block1.m_123341_() - (long)block2.m_123341_();
        long result = xDiff * xDiff + (zDiff = (long)block1.m_123343_() - (long)block2.m_123343_()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + zDiff);
        }
        return result;
    }

    public static BoundingBox getChunkAlignedBB(BlockPos pos, int chunkRadius) {
        int blockRadius = chunkRadius * 16;
        int x1 = pos.m_123341_() & 0xFFFFFFF0;
        int y1 = pos.m_123342_() & 0xFFFFFFF0;
        int z1 = pos.m_123343_() & 0xFFFFFFF0;
        return new BoundingBox(x1 - blockRadius, y1 - blockRadius, z1 - blockRadius, x1 + blockRadius + 15, y1 + blockRadius + 15, z1 + blockRadius + 15);
    }

    public static BlockEntity getTileEntity(@NotNull Level world, @NotNull BlockPos pos) {
        return world.m_7702_(pos);
    }

    public static List<ItemStack> getBlockDrops(@NotNull Level world, @NotNull BlockPos coords, int fortune, ItemStack stack, LivingEntity entity) {
        return world.m_8055_(coords).m_60724_(new LootContext.Builder((ServerLevel)world).m_78963_((float)fortune).m_78984_(LootContextParams.f_81462_, (Object)world.m_7702_(coords)).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)stack));
    }

    public static Block getBlock(@NotNull Level world, @NotNull BlockPos coords) {
        return world.m_8055_(coords).m_60734_();
    }

    public static BlockState getBlockState(@NotNull Level world, @NotNull BlockPos coords) {
        return world.m_8055_(coords);
    }

    public static boolean setBlock(@NotNull Level worldIn, @NotNull BlockPos coords, BlockState state, int flag) {
        return worldIn.m_7731_(coords, state, flag);
    }

    public static boolean tryMoveBaseCitizenEntityToXYZ(@NotNull AbstractEntityCitizen living, @NotNull BlockPos destination) {
        if (!(living instanceof LivingEntity)) {
            return false;
        }
        return EntityUtils.tryMoveLivingToXYZ((Mob)living, destination.m_123341_(), destination.m_123342_(), destination.m_123343_());
    }

    public static boolean tryMoveLivingToXYZ(@NotNull Mob living, @NotNull BlockPos destination) {
        return EntityUtils.tryMoveLivingToXYZ(living, destination.m_123341_(), destination.m_123342_(), destination.m_123343_());
    }

    public static void set(@NotNull BlockPos.MutableBlockPos pos, @NotNull BlockPos newPos) {
        pos.m_122178_(newPos.m_123341_(), newPos.m_123342_(), newPos.m_123343_());
    }

    public static boolean isEqual(@NotNull BlockPos coords, int x, int y, int z) {
        return coords.m_123341_() == x && coords.m_123342_() == y && coords.m_123343_() == z;
    }

    @NotNull
    public static BlockPos fromEntity(@NotNull Entity entity) {
        return new BlockPos(Mth.m_14107_((double)entity.m_20185_()), Mth.m_14107_((double)entity.m_20186_()), Mth.m_14107_((double)entity.m_20189_()));
    }

    @NotNull
    public static BlockPos getFloor(@NotNull BlockPos position, @NotNull Level world) {
        BlockPos floor = BlockPosUtil.getFloor(new BlockPos.MutableBlockPos(position.m_123341_(), position.m_123342_(), position.m_123343_()), 0, world);
        if (floor == null) {
            return position;
        }
        return floor;
    }

    @Nullable
    public static BlockPos getFloor(@NotNull BlockPos.MutableBlockPos position, int depth, @NotNull Level world) {
        if (depth > 50) {
            return null;
        }
        if (!EntityUtils.solidOrLiquid(world, (BlockPos)position)) {
            return BlockPosUtil.getFloor(position.m_122178_(position.m_123341_(), position.m_123342_() - 1, position.m_123343_()), depth + 1, world);
        }
        if (!EntityUtils.solidOrLiquid(world, (BlockPos)position.m_122178_(position.m_123341_(), position.m_123342_() + 1, position.m_123343_())) && !EntityUtils.solidOrLiquid(world, (BlockPos)position.m_122178_(position.m_123341_(), position.m_123342_() + 2, position.m_123343_()))) {
            return position.m_7949_();
        }
        return BlockPosUtil.getFloor(position.m_122178_(position.m_123341_(), position.m_123342_() + 1, position.m_123343_()), depth + 1, world);
    }

    public static Direction getFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.m_141950_((Vec3i)pos);
        return Direction.m_122372_((float)vector.m_123341_(), (float)vector.m_123342_(), (float)vector.m_123343_());
    }

    public static Direction getXZFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.m_141950_((Vec3i)pos);
        return Direction.m_122372_((float)vector.m_123341_(), (float)0.0f, (float)vector.m_123343_());
    }

    public static String calcDirection(@NotNull BlockPos building, @NotNull BlockPos pos) {
        StringBuilder dist = new StringBuilder();
        if (pos.m_123343_() > building.m_123343_() + 1) {
            dist.append(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.farmerhut.south").getString());
        } else if (pos.m_123343_() < building.m_123343_() - 1) {
            dist.append(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.farmerhut.north").getString());
        }
        if (pos.m_123341_() > building.m_123341_() + 1) {
            if (!dist.toString().isEmpty()) {
                dist.append('/');
            }
            dist.append(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.farmerhut.east").getString());
        } else if (pos.m_123341_() < building.m_123341_() - 1) {
            if (!dist.toString().isEmpty()) {
                dist.append('/');
            }
            dist.append(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.farmerhut.west").getString());
        }
        return dist.toString();
    }

    public static Rotation getRotationFromRotations(int rotations) {
        switch (rotations) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos findAround(Level world, BlockPos start, int vRange, int hRange, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (vRange < 1 && hRange < 1) {
            return null;
        }
        if (predicate.test((BlockGetter)world, start)) {
            return start;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < hRange + 2; ++i) {
            for (int steps = 1; steps <= vRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.m_142082_(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_142082_(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_142082_(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_142082_(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.m_142082_(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (world.m_141928_() > start.m_123342_() + (y += (y_offset *= -1))) continue;
            return null;
        }
        return null;
    }

    public static BlockPos findSpawnPosAround(Level worldReader, BlockPos start) {
        return BlockPosUtil.findAround(worldReader, start, 1, 1, (world, pos) -> world.m_8055_(pos).m_60767_() == Material.f_76296_ && world.m_8055_(pos.m_7494_()).m_60767_() == Material.f_76296_);
    }

    public static BlockPos getFurthestCorner(BlockPos startPos, BlockPos boxStart, BlockPos boxEnd) {
        int minX = Math.min(boxStart.m_123341_(), boxEnd.m_123341_());
        int minZ = Math.min(boxStart.m_123343_(), boxEnd.m_123343_());
        int minY = Math.min(boxStart.m_123342_(), boxEnd.m_123342_());
        int maxX = Math.max(boxStart.m_123341_(), boxEnd.m_123341_());
        int maxZ = Math.max(boxStart.m_123343_(), boxEnd.m_123343_());
        int maxY = Math.max(boxStart.m_123342_(), boxEnd.m_123342_());
        int cornerX = maxX;
        if (Math.abs(startPos.m_123341_() - minX) > Math.abs(startPos.m_123341_() - maxX)) {
            cornerX = minX;
        }
        int cornerY = maxY;
        if (Math.abs(startPos.m_123342_() - minY) > Math.abs(startPos.m_123342_() - maxY)) {
            cornerY = minY;
        }
        int cornerZ = maxZ;
        if (Math.abs(startPos.m_123343_() - minZ) > Math.abs(startPos.m_123343_() - maxZ)) {
            cornerZ = minZ;
        }
        return new BlockPos(cornerX, cornerY, cornerZ);
    }
}

