/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    private static final int AIR_SPACE_ABOVE_TO_CHECK = 2;
    private static final int DEFAULT_MOVE_RANGE = 3;
    private static final int TELEPORT_RANGE = 512;
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final int SCAN_RADIUS = 5;

    private EntityUtils() {
    }

    @NotNull
    public static Player getPlayerOfFakePlayer(@NotNull Player player, @NotNull Level world) {
        Player tempPlayer;
        if (player instanceof FakePlayer && (tempPlayer = world.m_46003_(player.m_142081_())) != null) {
            return tempPlayer;
        }
        return player;
    }

    public static Entity getPlayerByUUID(@NotNull Level world, @NotNull UUID id) {
        return world.m_46003_(id);
    }

    public static List<Entity> getEntitiesFromID(@NotNull Level world, @NotNull List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((Level)world).m_6815_(arg_0)).collect(Collectors.toList());
    }

    public static double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = Mth.m_14175_((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    public static boolean checkForFreeSpace(@NotNull Level world, @NotNull BlockPos groundPosition) {
        for (int i = 1; i < 2; ++i) {
            if (!EntityUtils.solidOrLiquid(world, groundPosition.m_6630_(i)) && !world.m_8055_(groundPosition.m_6630_(i)).m_204336_(BlockTags.f_13035_)) continue;
            return false;
        }
        return world.m_8055_(groundPosition).m_60767_().m_76333_();
    }

    public static boolean solidOrLiquid(@NotNull Level world, @NotNull BlockPos blockPos) {
        Material material = world.m_8055_(blockPos).m_60767_();
        return material.m_76333_() || material.m_76332_();
    }

    @Nullable
    public static BlockPos getSpawnPoint(Level world, BlockPos nearPoint) {
        return BlockPosUtil.findAround(world, nearPoint, 5, 5, (w, p) -> EntityUtils.checkValidSpawn(w, p, 2));
    }

    private static boolean checkValidSpawn(@NotNull BlockGetter world, BlockPos pos, int height) {
        for (int dy = 0; dy < height; ++dy) {
            BlockState state = world.m_8055_(pos.m_6630_(dy));
            if (state.m_204336_(ModTags.validSpawn) || !state.m_60767_().m_76334_()) continue;
            return false;
        }
        return world.m_8055_(pos.m_7495_()).m_60767_().m_76333_() || world.m_8055_(pos.m_6625_(2)).m_60767_().m_76333_();
    }

    public static boolean tryMoveLivingToXYZ(@NotNull Mob living, int x, int y, int z) {
        return EntityUtils.tryMoveLivingToXYZ(living, x, y, z, 1.0);
    }

    public static boolean tryMoveLivingToXYZ(@NotNull Mob living, int x, int y, int z, double speedFactor) {
        return living.m_21573_().m_26519_((double)x, (double)y, (double)z, speedFactor);
    }

    public static boolean isLivingAtSiteWithMove(@NotNull LivingEntity entity, int x, int y, int z) {
        return EntityUtils.isLivingAtSiteWithMove(entity, x, y, z, 3);
    }

    public static boolean isLivingAtSiteWithMove(@NotNull LivingEntity entity, int x, int y, int z, int range) {
        if (x == 0 && y == 0 && z == 0) {
            return false;
        }
        if (!EntityUtils.isLivingAtSite(entity, x, y, z, 512)) {
            BlockPos spawnPoint = EntityUtils.getSpawnPoint(entity.m_20193_(), new BlockPos(x, y, z));
            if (spawnPoint == null) {
                spawnPoint = new BlockPos(x, y, z);
            }
            entity.m_7678_((double)spawnPoint.m_123341_() + 0.5, (double)spawnPoint.m_123342_(), (double)spawnPoint.m_123343_() + 0.5, entity.m_146908_(), entity.m_146909_());
            return true;
        }
        return EntityUtils.isLivingAtSite(entity, x, y, z, range);
    }

    public static boolean isEntityAtPosition(Entity entity, Level world, Entity placer) {
        List<ItemStorage> existingReq = ItemStackUtils.getListOfStackForEntity(entity, placer);
        BlockPos pos = new BlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        return world.m_45976_(Entity.class, new AABB(pos.m_142082_(1, 1, 1), pos.m_142082_(-1, -1, -1))).stream().anyMatch(ent -> ent.m_20185_() == entity.m_20185_() && ent.m_20186_() == entity.m_20186_() && ent.m_20189_() == entity.m_20189_() && ItemStackUtils.getListOfStackForEntity(entity, placer).equals(existingReq));
    }

    public static boolean isEntityAtPosition(Entity entity, Level world, AbstractEntityCitizen entityCitizen) {
        if (entity != null) {
            return EntityUtils.isEntityAtPosition(entity, world, (Entity)entityCitizen);
        }
        return false;
    }

    public static boolean isLivingAtSite(@NotNull LivingEntity entityLiving, int x, int y, int z, int range) {
        BlockPos pos = new BlockPos(entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_());
        return pos.m_123331_(new Vec3i(x, y, z)) < MathUtils.square(range);
    }

    public static boolean isFlying(LivingEntity target) {
        return target != null && (target.f_19812_ || !target.m_20096_()) && target.f_19789_ <= 0.1f && target.f_19853_.m_46859_(target.m_142538_().m_6625_(2));
    }
}

