/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class NBTUtils {
    public static Stream<CompoundTag> streamCompound(ListTag list) {
        return NBTUtils.streamBase(list).filter(b -> b instanceof CompoundTag).map(b -> (CompoundTag)b);
    }

    public static Stream<Tag> streamBase(ListTag list) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new TagListIterator(list), 16), false);
    }

    public static Collector<CompoundTag, ?, ListTag> toListNBT() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            ListTag tagList = new ListTag();
            tagList.addAll((Collection)list);
            return tagList;
        });
    }

    private static class TagListIterator
    implements Iterator<Tag> {
        private final ListTag list;
        private int currentIndex = 0;

        private TagListIterator(ListTag list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.list.size();
        }

        @Override
        public Tag next() {
            return this.list.m_128728_(this.currentIndex++);
        }
    }
}

