/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.client.gui.WindowBuildBuilding;
import com.minecolonies.coremod.client.gui.WindowHutAllInventory;
import com.minecolonies.coremod.client.gui.WindowHutNameEntry;
import com.minecolonies.coremod.client.gui.WindowInfo;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildRequestMessage;
import java.util.Locale;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowModuleBuilding<B extends IBuildingView>
extends AbstractModuleWindow {
    protected final B building;
    private final Text title;
    private final Button buttonBuild;

    public AbstractWindowModuleBuilding(B building, String resource) {
        super((IBuildingView)building, resource);
        this.building = building;
        this.registerButton("build", this::buildClicked);
        this.registerButton("info", this::infoClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("editName", this::editName);
        this.registerButton("allinventory", this::allInventoryClicked);
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        this.buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        Button buttonInfo = (Button)this.findPaneOfTypeByID("info", Button.class);
        if (buttonInfo != null) {
            buttonInfo.setVisible(I18n.m_118936_((String)("com.minecolonies.coremod.info." + building.getSchematicName() + ".0")));
        }
    }

    private void editName() {
        @NotNull WindowHutNameEntry window = new WindowHutNameEntry((IBuildingView)this.building);
        window.open();
    }

    private void infoClicked() {
        @NotNull WindowInfo window = new WindowInfo((IBuildingView)this.building);
        window.open();
    }

    private void allInventoryClicked() {
        @NotNull WindowHutAllInventory window = new WindowHutAllInventory((IBuildingView)this.building, (BOWindow)this);
        window.open();
    }

    private void buildClicked() {
        String buttonLabel = this.buttonBuild.getTextAsString();
        if (buttonLabel.equalsIgnoreCase(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelbuild").getString()) || buttonLabel.equalsIgnoreCase(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelupgrade").getString())) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.BUILD, BlockPos.f_121853_));
        } else if (buttonLabel.equalsIgnoreCase(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelrepair").getString())) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.REPAIR, BlockPos.f_121853_));
        } else if (buttonLabel.equalsIgnoreCase(new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.canceldeconstruction").getString())) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.REMOVE, BlockPos.f_121853_));
        } else {
            @NotNull WindowBuildBuilding window = new WindowBuildBuilding(this.building.getColony(), (IBuildingView)this.building);
            window.open();
        }
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage((IBuildingView)this.building));
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateButtonBuild((IBuildingView)this.building);
    }

    public String getBuildingName() {
        return "com." + this.buildingView.getBuildingType().getRegistryName().m_135827_() + ".building." + this.buildingView.getBuildingType().getRegistryName().m_135815_();
    }

    private void updateButtonBuild(IBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelbuild"));
            } else {
                this.buttonBuild.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelupgrade"));
            }
        } else if (buildingView.isRepairing()) {
            this.buttonBuild.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelrepair"));
        } else if (buildingView.isDeconstructing()) {
            this.buttonBuild.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.canceldeconstruction"));
        } else {
            this.buttonBuild.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.buildrepair"));
        }
    }

    public void onOpened() {
        String name;
        super.onOpened();
        this.setPage(false, 0);
        String string = name = this.building.getCustomName().isEmpty() ? new TranslatableComponent(this.getBuildingName().toLowerCase(Locale.ROOT)).getString() : this.building.getCustomName();
        if (this.switchView != null && this.switchView.getID().equals("switchpageActions")) {
            this.title.setText(name);
            ((Text)this.findPaneOfTypeByID("level", Text.class)).setText(new TranslatableComponent("com.minecolonies.coremod.gui.townhall.buildingLevel").getString() + ": " + this.buildingView.getBuildingLevel());
        } else if (this.title != null) {
            this.title.setText(name + " " + this.buildingView.getBuildingLevel());
        }
    }
}

