/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.guardtype.registry.ModGuardTypes;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.minecolonies.coremod.network.messages.server.RemoveFromRallyingListMessage;
import com.minecolonies.coremod.network.messages.server.ToggleBannerRallyGuardsMessage;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class WindowBannerRallyGuards
extends AbstractWindowSkeleton {
    private static final String BUILD_TOOL_RESOURCE_SUFFIX = ":gui/windowbannerrallyguards.xml";
    private static final String LIST_GUARDTOWERS = "guardtowers";
    private static final String ICON_GUARD = "guardicon";
    private static final String BUTTON_REMOVE = "remove";
    private static final String BUTTON_RALLY = "rally";
    private static final String LABEL_GUARDTYPE = "guardtype";
    private static final String LABEL_POSITION = "position";
    private ScrollingList guardTowerList;
    private ItemStack banner = null;

    public WindowBannerRallyGuards(ItemStack banner) {
        super("minecolonies:gui/windowbannerrallyguards.xml");
        this.banner = banner;
        this.registerButton(BUTTON_REMOVE, this::removeClicked);
        this.registerButton(BUTTON_RALLY, this::rallyClicked);
    }

    public void onOpened() {
        this.guardTowerList = (ScrollingList)this.findPaneOfTypeByID(LIST_GUARDTOWERS, ScrollingList.class);
        if (ItemBannerRallyGuards.isActive(this.banner)) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_RALLY, ButtonImage.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.item.bannerrallyguards.gui.dismiss"));
        } else {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_RALLY, ButtonImage.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.item.bannerrallyguards.gui.rally"));
        }
        this.guardTowerList.setDataProvider(() -> ItemBannerRallyGuards.getGuardTowerViews(this.banner).size(), (index, rowPane) -> {
            List<Pair<ILocation, AbstractBuildingGuards.View>> guardTowers = ItemBannerRallyGuards.getGuardTowerViews(this.banner);
            if (index < 0 || index >= guardTowers.size()) {
                return;
            }
            Pair<ILocation, AbstractBuildingGuards.View> guardTower = guardTowers.get(index);
            ItemIcon exampleStackDisplay = (ItemIcon)rowPane.findPaneOfTypeByID(ICON_GUARD, ItemIcon.class);
            AbstractBuildingGuards.View guardTowerView = (AbstractBuildingGuards.View)guardTower.getSecond();
            if (guardTowerView != null) {
                exampleStackDisplay.setItem(new ItemStack((ItemLike)Items.f_42383_));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_GUARDTYPE, Text.class)).setText(LanguageHandler.format((String)ModGuardTypes.knight.getJobTranslationKey(), (Object[])new Object[0]) + "|" + LanguageHandler.format((String)ModGuardTypes.ranger.getJobTranslationKey(), (Object[])new Object[0]) + ": " + guardTowerView.getGuards().size());
                ((Text)rowPane.findPaneOfTypeByID(LABEL_POSITION, Text.class)).setText(((ILocation)guardTower.getFirst()).toString());
            } else {
                exampleStackDisplay.setItem(new ItemStack((ItemLike)Items.f_42572_));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_GUARDTYPE, Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.item.bannerrallyguards.gui.towermissing"));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_GUARDTYPE, Text.class)).setColors(Color.rgbaToInt((int)255, (int)0, (int)0, (int)1));
                ((Text)rowPane.findPaneOfTypeByID(LABEL_POSITION, Text.class)).setText(((ILocation)guardTower.getFirst()).toString());
            }
        });
    }

    private void removeClicked(@NotNull Button button) {
        int row = this.guardTowerList.getListElementIndexByPane((Pane)button);
        List<Pair<ILocation, AbstractBuildingGuards.View>> guardTowers = ItemBannerRallyGuards.getGuardTowerViews(this.banner);
        if (guardTowers.size() > row && row >= 0) {
            ILocation locationToRemove = (ILocation)guardTowers.get(row).getFirst();
            Network.getNetwork().sendToServer(new RemoveFromRallyingListMessage(this.banner, locationToRemove));
            ItemBannerRallyGuards.removeGuardTowerAtLocation(this.banner, locationToRemove);
        }
    }

    private void rallyClicked(@NotNull Button button) {
        Network.getNetwork().sendToServer(new ToggleBannerRallyGuardsMessage(this.banner));
        this.close();
    }
}

