/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.network.messages.server.BuildToolPlaceMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildDecoration
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowbuildbuilding.xml";
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    @NotNull
    private final List<Tuple<String, BlockPos>> builders = new ArrayList<Tuple<String, BlockPos>>();
    private DropDownList buildersDropDownList;
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private final BuildToolPlaceMessage placementMessage;
    private final StructureName structureName;
    private final BlockPos structurePos;

    public WindowBuildDecoration(BuildToolPlaceMessage msg, BlockPos pos, StructureName structure) {
        super("minecolonies:gui/windowbuildbuilding.xml");
        this.placementMessage = msg;
        this.structureName = structure;
        this.structurePos = pos;
        this.registerButton("build", this::confirmedBuild);
        this.registerButton("cancel", this::close);
        ((Button)this.findPaneOfTypeByID("build", Button.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.build"));
        ((Button)this.findPaneOfTypeByID("deconstruct", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("repair", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("nextStyle", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("previousStyle", Button.class)).hide();
        ((DropDownList)this.findPaneOfTypeByID("style", DropDownList.class)).disable();
    }

    public void onOpened() {
        this.updateBuilders();
        this.updateResources();
    }

    private void updateBuilders() {
        IColonyView colony = (IColonyView)IColonyManager.getInstance().getIColony((Level)Minecraft.m_91087_().f_91073_, this.structurePos);
        if (colony == null) {
            if (this.structureName.getStyle().equals("supplycamp") || this.structureName.getStyle().equals("supplyship")) {
                LanguageHandler.sendPlayerMessage((Player)Minecraft.m_91087_().f_91074_, (String)"com.minecolonies.coremod.workorder.nocolonyyet", (Object[])new Object[0]);
            } else {
                LanguageHandler.sendPlayerMessage((Player)Minecraft.m_91087_().f_91074_, (String)"com.minecolonies.coremod.workorder.outofcolony", (Object[])new Object[]{this.structureName.getSchematic(), this.structurePos.m_123341_(), this.structurePos.m_123343_()});
            }
            this.close();
            return;
        }
        this.builders.clear();
        this.builders.add((Tuple<String, BlockPos>)new Tuple((Object)(new TranslatableComponent(ModJobs.builder.getTranslationKey()).getString() + ":"), (Object)BlockPos.f_121853_));
        this.builders.addAll(colony.getBuildings().stream().filter(build -> build instanceof AbstractBuildingBuilderView && !((AbstractBuildingBuilderView)build).getWorkerName().isEmpty() && build.getBuildingType() != ModBuildings.miner).map(build -> new Tuple((Object)((AbstractBuildingBuilderView)build).getWorkerName(), (Object)build.getPosition())).sorted(Comparator.comparing(item -> ((BlockPos)item.m_14419_()).m_123331_((Vec3i)this.structurePos))).collect(Collectors.toList()));
        this.initBuilderNavigation();
    }

    private void initBuilderNavigation() {
        this.buildersDropDownList = (DropDownList)this.findPaneOfTypeByID("worker", DropDownList.class);
        this.buildersDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowBuildDecoration.this.builders.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildDecoration.this.builders.size()) {
                    return (String)WindowBuildDecoration.this.builders.get(index).m_14418_();
                }
                return "";
            }
        });
        this.buildersDropDownList.setSelectedIndex(0);
    }

    private void updateResources() {
        StructurePhasePlacementResult result;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        this.resources.clear();
        LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler((Level)world, this.structurePos, this.structureName.toString(), new PlacementSettings(), true);
        String md5 = Structures.getMD5((String)this.structureName.toString());
        if (!structure.hasBluePrint() || !structure.isCorrectMD5(md5)) {
            if (!structure.hasBluePrint()) {
                Log.getLogger().info("Template structure " + this.structureName + " missing");
            } else {
                Log.getLogger().info("structure " + this.structureName + " md5 error");
            }
            Log.getLogger().info("Request To Server for structure " + this.structureName);
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                com.ldtteam.structurize.Network.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(this.structureName.toString()));
                return;
            }
            Log.getLogger().error("WindowMinecoloniesBuildTool: Need to download schematic on a standalone client/server. This should never happen", (Throwable)new Exception());
        }
        StructurePlacer placer = new StructurePlacer((IStructureHandler)structure);
        BlockPos progressPos = AbstractBlueprintIterator.NULL_POS;
        do {
            result = placer.executeStructureStep((Level)world, null, progressPos, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(), true);
            progressPos = result.getIteratorPos();
            for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                this.addNeededResource(stack, stack.m_41613_());
            }
        } while (result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED);
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
        this.updateResourceList();
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        int hashCode = res.m_41782_() ? res.m_41783_().hashCode() : 0;
        String key = res.m_41778_() + "-" + hashCode;
        ItemStorage resource = this.resources.get(key);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.resources.put(key, resource);
    }

    public void updateResourceList() {
        ScrollingList recourseList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        recourseList.enable();
        recourseList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        recourseList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(resource.getItemStack().m_41786_().getString());
                quantityLabel.setText(Integer.toString(resource.getAmount()));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack itemIcon = new ItemStack((ItemLike)resource.getItem(), 1);
                itemIcon.m_41751_(resource.getItemStack().m_41783_());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(itemIcon);
            }
        });
    }

    private void confirmedBuild() {
        this.placementMessage.builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.f_121853_ : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).m_14419_();
        Network.getNetwork().sendToServer(this.placementMessage);
        this.close();
    }
}

