/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.network.messages.server.DecorationBuildRequestMessage;
import com.minecolonies.coremod.network.messages.server.DecorationControllerUpdateMessage;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WindowDecorationController
extends AbstractWindowSkeleton {
    private static final int MAX_NAME_LENGTH = 200;
    private static final String HUT_NAME_RESOURCE_SUFFIX = ":gui/windowdecorationcontroller.xml";
    private static final String INPUT_LEVEL = "level";
    private final TileEntityDecorationController controller;
    private final Level world;
    private boolean isCreative;

    public WindowDecorationController(BlockPos b) {
        super("minecolonies:gui/windowdecorationcontroller.xml");
        Optional<IWorkOrderView> wo;
        this.world = Minecraft.m_91087_().f_91073_;
        this.isCreative = Minecraft.m_91087_().f_91074_.m_7500_();
        this.controller = (TileEntityDecorationController)this.world.m_7702_(b);
        this.registerButton("build", this::confirmClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("done", this::doneClicked);
        this.registerButton("cancel", this::cancelClicked);
        TextField textFieldName = (TextField)this.findPaneOfTypeByID("name", TextField.class);
        textFieldName.setText(this.controller.getSchematicPath().replaceAll("\\d$", ""));
        TextField textFieldLevel = (TextField)this.findPaneOfTypeByID(INPUT_LEVEL, TextField.class);
        textFieldLevel.setText(String.valueOf(this.controller.getTier()));
        IColonyView view = IColonyManager.getInstance().getClosestColonyView(this.world, this.controller.m_58899_());
        Button buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        if (view != null && (wo = view.getWorkOrders().stream().filter(w -> w.getLocation().equals((Object)this.controller.m_58899_())).findFirst()).isPresent()) {
            if (wo.get().getWorkOrderType() == WorkOrderType.BUILD) {
                if (this.controller.getTier() == 0) {
                    buttonBuild.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelBuild"));
                } else {
                    buttonBuild.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelUpgrade"));
                }
                this.findPaneByID("repair").hide();
            } else if (wo.get().getWorkOrderType() == WorkOrderType.BUILD) {
                buttonBuild.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.workerhuts.cancelRepair"));
                this.findPaneByID("repair").hide();
            }
        }
        if (this.controller.getTier() == 0) {
            this.findPaneByID("repair").hide();
        }
        LoadOnlyStructureHandler structure = null;
        try {
            String structureName = this.controller.getSchematicPath().replace("/structurize/", "").replaceAll("\\d$", "");
            structure = new LoadOnlyStructureHandler(this.world, b, structureName + (this.controller.getTier() + 1), new PlacementSettings(), true);
        }
        catch (Exception e) {
            Log.getLogger().info("Unable to load structure: " + this.controller.getSchematicPath() + " for decoration controller!");
        }
        this.findPaneByID("infotextnoupgrade").hide();
        if (structure == null || !structure.hasBluePrint()) {
            this.findPaneByID("build").hide();
            this.findPaneByID("infotextnoupgrade").show();
        }
        if (!this.isCreative) {
            textFieldName.disable();
            textFieldLevel.disable();
            this.findPaneByID("done").hide();
        } else {
            ((Text)this.findPaneOfTypeByID("nameLabel", Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.deco.namescan"));
        }
    }

    private void cancelClicked() {
        this.close();
    }

    private void doneClicked() {
        if (this.isCreative) {
            String name = ((TextField)this.findPaneOfTypeByID("name", TextField.class)).getText();
            if (name.length() > 200) {
                name = name.substring(0, 200);
                LanguageHandler.sendPlayerMessage((Player)Minecraft.m_91087_().f_91074_, (String)"com.minecolonies.coremod.gui.name.toolong", (Object[])new Object[]{name});
            }
            String levelString = ((TextField)this.findPaneOfTypeByID(INPUT_LEVEL, TextField.class)).getText();
            try {
                int level = Integer.parseInt(levelString);
                Network.getNetwork().sendToServer(new DecorationControllerUpdateMessage(this.controller.m_58899_(), name, level));
                this.controller.setSchematicPath(name + level);
                this.controller.setTier(level);
                this.close();
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Error parsing number: " + levelString, (Throwable)ex);
            }
        }
    }

    private void confirmClicked() {
        Network.getNetwork().sendToServer(new DecorationBuildRequestMessage(this.controller.m_58899_(), this.controller.getSchematicName().substring(this.controller.getSchematicName().lastIndexOf("/") + 1).replaceAll("\\d$", ""), this.controller.getSchematicPath().replaceAll("\\d$", ""), this.controller.getTier() + 1, (ResourceKey<Level>)this.world.m_46472_()));
        this.close();
    }

    private void repairClicked() {
        Network.getNetwork().sendToServer(new DecorationBuildRequestMessage(this.controller.m_58899_(), this.controller.getSchematicName().substring(this.controller.getSchematicName().lastIndexOf("/") + 1).replaceAll("\\d$", ""), this.controller.getSchematicPath().replaceAll("\\d$", ""), this.controller.getTier(), (ResourceKey<Level>)this.world.m_46472_()));
        this.close();
    }
}

