/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingRegistry;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowBuildDecoration;
import com.minecolonies.coremod.client.render.worldevent.HighlightManager;
import com.minecolonies.coremod.items.ItemSupplyCampDeployer;
import com.minecolonies.coremod.items.ItemSupplyChestDeployer;
import com.minecolonies.coremod.network.messages.server.BuildToolPasteMessage;
import com.minecolonies.coremod.network.messages.server.BuildToolPlaceMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowMinecoloniesBuildTool
extends WindowBuildTool {
    private static final String RENDER_BOX_CATEGORY = "placement";

    public WindowMinecoloniesBuildTool(@Nullable BlockPos pos, String structureName, int rotation, int groundstyle) {
        super(pos, structureName, rotation, groundstyle);
    }

    public WindowMinecoloniesBuildTool(@Nullable BlockPos pos, int groundstyle) {
        super(pos, groundstyle);
    }

    public void place(StructureName structureName) {
        BlockPos offset = Settings.instance.getActiveStructure().getPrimaryBlockOffset();
        BlockState state = Settings.instance.getActiveStructure().getBlockState(offset);
        BuildToolPlaceMessage msg = new BuildToolPlaceMessage(structureName.toString(), structureName.getLocalizedName(), Settings.instance.getPosition(), Settings.instance.getRotation(), structureName.isHut(), Settings.instance.getMirror(), state);
        if (structureName.isHut()) {
            Network.getNetwork().sendToServer(msg);
        } else {
            Minecraft.m_91087_().m_6937_(() -> ((WindowBuildDecoration)new WindowBuildDecoration(msg, Settings.instance.getPosition(), structureName)).open());
        }
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean pasteDirectly() {
        return false;
    }

    public void paste(StructureName name, boolean complete) {
        BlockPos offset = Settings.instance.getActiveStructure().getPrimaryBlockOffset();
        BlockState state = Settings.instance.getActiveStructure().getBlockState(offset);
        Network.getNetwork().sendToServer(new BuildToolPasteMessage(name.toString(), name.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), name.isHut(), Settings.instance.getMirror(), complete, state));
    }

    public void checkAndPlace() {
        ArrayList<PlacementError> placementErrorList = new ArrayList<PlacementError>();
        String schemName = Settings.instance.getStaticSchematicName();
        if (schemName.contains("supplyship") || schemName.contains("nethership")) {
            if (ItemSupplyChestDeployer.canShipBePlaced((Level)Minecraft.m_91087_().f_91073_, Settings.instance.getPosition(), Settings.instance.getActiveStructure(), placementErrorList, (Player)Minecraft.m_91087_().f_91074_)) {
                super.pasteNice();
            } else {
                LanguageHandler.sendPlayerMessage((Player)Minecraft.m_91087_().f_91074_, (String)"item.supplyChestDeployer.invalid", (Object[])new Object[0]);
            }
        } else if (schemName.contains("supplycamp") && ItemSupplyCampDeployer.canCampBePlaced((Level)Minecraft.m_91087_().f_91073_, Settings.instance.getPosition(), placementErrorList, (Player)Minecraft.m_91087_().f_91074_)) {
            super.pasteNice();
        }
        HighlightManager.clearCategory(RENDER_BOX_CATEGORY);
        if (!placementErrorList.isEmpty()) {
            LanguageHandler.sendPlayerMessage((Player)Minecraft.m_91087_().f_91074_, (String)"item.supply.badblocks", (Object[])new Object[0]);
            for (PlacementError error : placementErrorList) {
                HighlightManager.addRenderBox(RENDER_BOX_CATEGORY, new HighlightManager.TimedBoxRenderData().setPos(error.getPos()).setRemovalTimePoint(Minecraft.m_91087_().f_91073_.m_46467_() + 144000L).addText(LanguageHandler.translateKey((String)("item.supply.error." + error.getType().toString().toLowerCase()))).setColor(-65536));
            }
        }
        if (!Screen.m_96638_()) {
            super.cancelClicked();
        }
    }

    public void cancelClicked() {
        super.cancelClicked();
        HighlightManager.clearCategory(RENDER_BOX_CATEGORY);
    }

    public boolean hasMatchingBlock(@NotNull Inventory inventory, String hut) {
        String name = hut.equals("citizen") ? "home" : hut;
        return InventoryUtils.hasItemInProvider((ICapabilityProvider)inventory.f_35978_, item -> item.m_41720_() instanceof BlockItem && StructureName.HUTS.contains(hut) && ((BlockItem)item.m_41720_()).m_40614_() == ((BuildingEntry)IBuildingRegistry.getInstance().getValue(new ResourceLocation("minecolonies", name))).getBuildingBlock());
    }
}

