/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WindowCrafting
extends AbstractContainerScreen<ContainerCrafting> {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("minecolonies", "textures/gui/crafting2x2.png");
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES3X3 = new ResourceLocation("minecolonies", "textures/gui/crafting3x3.png");
    private static final int BUTTON_X_OFFSET = 1;
    private static final int BUTTON_Y_POS = 170;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int GUI_COLOR = 0x404040;
    private static final int X_OFFSET = 97;
    private static final int Y_OFFSET = 8;
    private static final int CRAFTING_GRID_SIZE = 4;
    private static final int MAX_CRAFTING_GRID_SIZE = 9;
    private final AbstractBuildingView building;
    private final boolean completeCrafting;
    private final CraftingModuleView module;

    public WindowCrafting(ContainerCrafting container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.building = (AbstractBuildingView)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)playerInventory.f_35978_.f_19853_.m_46472_(), container.getPos());
        this.module = this.building.getModuleViewMatching(CraftingModuleView.class, v -> v.getId().equals(container.getModuleId()));
        this.completeCrafting = this.module.canLearnLargeRecipes();
    }

    @NotNull
    public AbstractBuildingView getBuildingView() {
        return this.building;
    }

    public boolean isCompleteCrafting() {
        return this.completeCrafting;
    }

    protected void m_7856_() {
        super.m_7856_();
        String buttonDisplay = this.module.canLearnCraftingRecipes() ? I18n.m_118938_((String)"gui.done", (Object[])new Object[0]) : new TranslatableComponent("com.minecolonies.coremod.gui.recipe.full").getString();
        Button doneButton = new Button(this.f_97735_ + 1, this.f_97736_ + 170, 150, 20, (Component)new TextComponent(buttonDisplay), (Button.OnPress)new OnButtonPress());
        this.m_142416_((GuiEventListener)doneButton);
        if (!this.module.canLearnCraftingRecipes()) {
            doneButton.f_93623_ = false;
        }
    }

    protected void m_7027_(@NotNull PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"container.crafting", (Object[])new Object[0]), 97.0f, 8.0f, 0x404040);
    }

    protected void m_7286_(@NotNull PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.completeCrafting) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)CRAFTING_TABLE_GUI_TEXTURES3X3);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)CRAFTING_TABLE_GUI_TEXTURES);
        }
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_6305_(@NotNull PoseStack stack, int x, int y, float z) {
        this.m_7333_(stack);
        super.m_6305_(stack, x, y, z);
        this.m_7025_(stack, x, y);
    }

    public class OnButtonPress
    implements Button.OnPress {
        public void m_93750_(Button button) {
            if (WindowCrafting.this.module.canLearnCraftingRecipes()) {
                LinkedList<ItemStorage> input = new LinkedList<ItemStorage>();
                for (int i = 0; i < (WindowCrafting.this.completeCrafting ? 9 : 4); ++i) {
                    ItemStack stack = ((ContainerCrafting)((WindowCrafting)WindowCrafting.this).f_97732_).craftMatrix.m_8020_(i);
                    ItemStack copy = stack.m_41777_();
                    ItemStackUtils.setSize(copy, 1);
                    input.add(new ItemStorage(copy));
                }
                ItemStack primaryOutput = ((ContainerCrafting)((WindowCrafting)WindowCrafting.this).f_97732_).craftResult.m_8020_(0).m_41777_();
                List<ItemStack> secondaryOutputs = ((ContainerCrafting)WindowCrafting.this.f_97732_).getRemainingItems();
                if (!ItemStackUtils.isEmpty(primaryOutput).booleanValue()) {
                    Network.getNetwork().sendToServer(new AddRemoveRecipeMessage(WindowCrafting.this.building, input, WindowCrafting.this.completeCrafting ? 3 : 2, primaryOutput, secondaryOutputs, false, WindowCrafting.this.module.getId()));
                }
            }
        }
    }
}

